/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2014-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.jersey.tests.e2e.container;

import java.io.IOException;
import java.util.zip.GZIPInputStream;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;

import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;

import org.junit.Test;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

/**
 * @author Michal Gajdos
 */
public class GzipContentEncodingTest extends JerseyContainerTest {

    @Path("/")
    public static class Resource {

        @GET
        public String get() {
            return "GET";
        }

        @POST
        public String post(final String content) {
            return content;
        }
    }

    @Override
    protected Application configure() {
        return new ResourceConfig(Resource.class, EncodingFilter.class, GZipEncoder.class);
    }

    @Override
    protected void configureClient(final ClientConfig config) {
        config.register(new ReaderInterceptor() {
            @Override
            public Object aroundReadFrom(final ReaderInterceptorContext context) throws IOException, WebApplicationException {
                context.setInputStream(new GZIPInputStream(context.getInputStream()));
                return context.proceed();
            }
        });
    }

    @Test
    public void testGet() {
        final Response response = target().request()
                .header(HttpHeaders.ACCEPT_ENCODING, "gzip")
                .get();

        assertThat(response.readEntity(String.class), is("GET"));
    }

    @Test
    public void testPost() {
        final Response response = target().request()
                .header(HttpHeaders.ACCEPT_ENCODING, "gzip")
                .post(Entity.text("POST"));

        assertThat(response.readEntity(String.class), is("POST"));
    }
}
