<!--

    DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.

    Copyright (c) 2015 Oracle and/or its affiliates. All rights reserved.

    The contents of this file are subject to the terms of either the GNU
    General Public License Version 2 only ("GPL") or the Common Development
    and Distribution License("CDDL") (collectively, the "License").  You
    may not use this file except in compliance with the License.  You can
    obtain a copy of the License at
    http://glassfish.java.net/public/CDDL+GPL_1_1.html
    or packager/legal/LICENSE.txt.  See the License for the specific
    language governing permissions and limitations under the License.

    When distributing the software, include this License Header Notice in each
    file and include the License file at packager/legal/LICENSE.txt.

    GPL Classpath Exception:
    Oracle designates this particular file as subject to the "Classpath"
    exception as provided by Oracle in the GPL Version 2 section of the License
    file that accompanied this code.

    Modifications:
    If applicable, add the following below the License Header, with the fields
    enclosed by brackets [] replaced by your own identifying information:
    "Portions Copyright [year] [name of copyright owner]"

    Contributor(s):
    If you wish your version of this file to be governed by only the CDDL or
    only the GPL Version 2, indicate your decision by adding "[Contributor]
    elects to include this software in this distribution under the [CDDL or GPL
    Version 2] license."  If you don't indicate a single choice of license, a
    recipient has the option to distribute your version of this file under
    either the CDDL, the GPL Version 2 or to extend the choice of license to
    its licensees as provided above.  However, if you add GPL Version 2 code
    and therefore, elected the GPL Version 2 license, then the option applies
    and therefore, elected the GPL Version 2 license, then the option applies
    only if the new code is made subject to such option by the copyright
    holder.

-->

Extended WADL WebApp Example
============================

This example demonstrates how to get an extended WADL generated by
jersey.

Contents
--------

The description of what's done here you'll find in the [jersey 1
wiki](https://wikis.oracle.com/display/Jersey/HowToConfigureExtendedWADL).

The difference in configuration against jersey 1.x is in property
configuring the custom WadlGeneratorConfig. Instead of property key
'com.sun.jersey.config.property.WadlGeneratorConfig' use the property
key 'jersey.config.server.wadl.generatorConfig'. Also check pom.xml of
this sample to see other configuration differences.

Just as a pointer at which files you might have a look:

-   pom.xml
-   src/main/webapp/WEB-INF/web.xml
-   src/main/resources/\*
-   src/main/xsd/schema.xsd
-   org.glassfish.jersey.examples.extendedwadl.SampleWadlGeneratorConfig

The mapping of the URI path space is presented in the following table:

URI path                        | Resource class   | HTTP methods   | Description
------------------------------- | ---------------- | -------------- | ---------------------------------------------------------------------------------------------------------------
**_/items_**                    | ItemsResource    | POST           | Creates a new item and allocates a new unique URI for it, the new URI is returned back in the Location header
**_/items/{id}_**               | ItemResource     | GET            | Returns an item with the id={id}
**_/items/{id}/value/{val}_**   | ItemResource     | PUT            | Updates the value of the item with the id={id} with the new value {val}

Running the Example
-------------------

If you are working with Jersey GlassFish update center module installed
into your existing GlassFish instance, you will need to follow
instructions at [the module README file](../../README.html) in order to
deploy the example.

Otherwise, you can run the example using embedded GlassFish as follows:

You can run the example using Grizzly as follows:

>     mvn clean package exec:java

Get the generated wadl via curl:

>     curl http://localhost:8080/extended-wadl-webapp/application.wadl

Or from a web browser, visit:

>     http://localhost:8080/extended-wadl-webapp/application.wadl
