/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.testing.hk2testng;

import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.TYPE;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import org.glassfish.hk2.utilities.Binder;

/**
 * This annotation specifies what HK2 service locator and binders should be used
 * to instantiate and inject the test class it is annotated with.
 *
 * @author saden
 */
@Documented
@Inherited
@Retention(java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(TYPE)
public @interface HK2 {

    /**
     * The name of the service locator that will be used.
     *
     * @return the name of the service locator
     */
    String value() default "hk2-testng-locator";

    /**
     * Create a service locator and populate it with services defined in
     * "META-INF/hk2-locator/default" inhabitant files found in the classpath.
     *
     * @return true if the classpath should be scanned for inhabitant files.
     */
    boolean populate() default true;

    /**
     * A list of binders that should be loaded.
     *
     * @return a list of binders classes
     */
    Class<? extends Binder>[] binders() default {};

    /**
     * If true then the PerThread scope will be enabled
     * in the associated service locator
     *
     * @return true if PerThread scope should be enabled
     */
    boolean enablePerThread() default true;

    /**
     * If true then the InheritableThread scope will be enabled in the
     * associated service locator
     *
     * @return true if InheritableThread scope should be enabled
     */
    boolean enableInheritableThread() default true;

    /**
     * If true then the Immediate scope will be enabled
     * in the associated service locator
     *
     * @return true if Immediate scope should be enabled
     */
    boolean enableImmediate() default true;

    /**
     * If true then the lookup exceptions will be thrown
     * back to the caller
     *
     * @return true if lookup exceptions should be thrown
     * back to the caller
     */
    boolean enableLookupExceptions() default true;

    /**
     * If true then events will be enabled
     *
     * @return true if events should be enabled
     */
    boolean enableEvents() default true;

}
