/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.strprotocol.IMessageSender;

public abstract class BaseMessageSender
implements IMessageSender {
    private boolean m_debug = false;
    protected Socket m_clientSocket;
    private String m_host;
    private int m_port;
    protected Object m_ackLock = new Object();
    private boolean m_requestStopReceiver;
    protected OutputStream m_outStream;
    private PrintWriter m_outWriter;
    protected volatile InputStream m_inStream;
    protected volatile BufferedReader m_inReader;
    private ReaderThread m_readerThread;
    private boolean m_ack;
    private int m_serial = 0;
    private String m_latestAck;

    public BaseMessageSender(String host, int port, boolean ack) {
        this.m_host = host;
        this.m_port = port;
        this.m_ack = ack;
    }

    @Override
    public void connect() throws IOException {
        BaseMessageSender.p("Waiting for Eclipse client on " + this.m_host + ":" + this.m_port);
        while (true) {
            try {
                this.m_clientSocket = new Socket(this.m_host, this.m_port);
                BaseMessageSender.p("Received a connection from Eclipse on " + this.m_host + ":" + this.m_port);
                this.m_outStream = this.m_clientSocket.getOutputStream();
                this.m_outWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.m_outStream)));
                this.m_inStream = this.m_clientSocket.getInputStream();
                try {
                    this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException ueex) {
                    this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream));
                }
                BaseMessageSender.p("Connection established, starting reader thread");
                this.m_readerThread = new ReaderThread();
                this.m_readerThread.start();
                return;
            }
            catch (ConnectException ex) {
                try {
                    Thread.sleep(4000L);
                    continue;
                }
                catch (InterruptedException handled) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    private void sendAdminMessage(String message) {
        this.m_outWriter.println(message);
        this.m_outWriter.flush();
    }

    @Override
    public void sendAck() {
        BaseMessageSender.p("Sending ACK " + this.m_serial);
        this.sendAdminMessage(">ACK");
    }

    @Override
    public void sendStop() {
        this.sendAdminMessage(">STOP");
    }

    @Override
    public void initReceiver() throws SocketTimeoutException {
        if (this.m_inStream != null) {
            BaseMessageSender.p("Receiver already initialized");
        }
        ServerSocket serverSocket = null;
        try {
            BaseMessageSender.p("initReceiver on port " + this.m_port);
            serverSocket = new ServerSocket(this.m_port);
            serverSocket.setSoTimeout(5000);
            Socket socket = null;
            while (!this.m_requestStopReceiver) {
                try {
                    if (this.m_debug) {
                        BaseMessageSender.p("polling the client connection");
                    }
                    socket = serverSocket.accept();
                    break;
                }
                catch (IOException ioe) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (socket != null) {
                this.m_inStream = socket.getInputStream();
                this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream));
                this.m_outStream = socket.getOutputStream();
                this.m_outWriter = new PrintWriter(new OutputStreamWriter(this.m_outStream));
            }
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (IOException ioe) {
            this.closeQuietly(serverSocket);
        }
    }

    @Override
    public void stopReceiver() {
        this.m_requestStopReceiver = true;
    }

    @Override
    public void shutDown() {
        this.closeQuietly(this.m_outStream);
        this.m_outStream = null;
        if (null != this.m_readerThread) {
            this.m_readerThread.interrupt();
        }
        this.closeQuietly(this.m_inReader);
        this.m_inReader = null;
        this.closeQuietly(this.m_clientSocket);
        this.m_clientSocket = null;
    }

    private void closeQuietly(Closeable c) {
        block3: {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    if (!this.m_debug) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAck() {
        if (this.m_ack) {
            try {
                BaseMessageSender.p("Message sent, waiting for ACK...");
                Object object = this.m_ackLock;
                synchronized (object) {
                    this.m_ackLock.wait();
                }
                BaseMessageSender.p("... ACK received:" + this.m_latestAck);
            }
            catch (InterruptedException handled) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void p(String msg) {
        if (RemoteTestNG.isVerbose()) {
            System.out.println("[BaseMessageSender] " + msg);
        }
    }

    private class ReaderThread
    extends Thread {
        public ReaderThread() {
            super("ReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    BaseMessageSender.p("ReaderThread waiting for an admin message");
                    String message = BaseMessageSender.this.m_inReader.readLine();
                    BaseMessageSender.p("ReaderThread received admin message:" + message);
                    while (message != null) {
                        if (BaseMessageSender.this.m_debug) {
                            BaseMessageSender.p("Admin message:" + message);
                        }
                        boolean acknowledge = message.startsWith(">ACK");
                        boolean stop = ">STOP".equals(message);
                        if (acknowledge || stop) {
                            if (acknowledge) {
                                BaseMessageSender.p("Received ACK:" + message);
                                BaseMessageSender.this.m_latestAck = message;
                            }
                            Object object = BaseMessageSender.this.m_ackLock;
                            synchronized (object) {
                                BaseMessageSender.this.m_ackLock.notifyAll();
                            }
                            if (stop) {
                                break;
                            }
                        } else {
                            BaseMessageSender.p("Received unknown message: '" + message + "'");
                        }
                        message = BaseMessageSender.this.m_inReader != null ? BaseMessageSender.this.m_inReader.readLine() : null;
                    }
                }
                catch (IOException ioe) {
                    if (!RemoteTestNG.isVerbose()) break block11;
                    ioe.printStackTrace();
                }
            }
        }
    }
}

