/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote;

import java.util.List;
import org.testng.CommandLineArgs;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.remote.IRemoteTestNG;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessageSender;
import org.testng.remote.strprotocol.JsonMessageSender;
import org.testng.remote.strprotocol.MessageHub;
import org.testng.remote.strprotocol.SerializedMessageSender;
import org.testng.remote.strprotocol.StdoutMessageSender;
import org.testng.remote.strprotocol.StringMessageSender;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.xml.XmlSuite;

public abstract class AbstractRemoteTestNG
extends TestNG
implements IRemoteTestNG {
    private static final String LOCALHOST = "localhost";
    protected ITestRunnerFactory m_customTestRunnerFactory;
    private String m_host;
    private Integer m_port = null;
    private Integer m_serPort = null;
    private String m_protocol;
    private boolean m_debug;
    private boolean m_dontExit;
    private boolean m_ack;

    @Override
    public void dontExit(boolean dontExit) {
        this.m_dontExit = dontExit;
    }

    @Override
    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    @Override
    public void setAck(boolean ack) {
        this.m_ack = ack;
    }

    @Override
    public void setHost(String host) {
        this.m_host = AbstractRemoteTestNG.defaultIfStringEmpty(host, LOCALHOST);
    }

    @Override
    public void setSerPort(Integer serPort) {
        this.m_serPort = serPort;
    }

    @Override
    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    @Override
    public void setPort(Integer port) {
        this.m_port = port;
    }

    @Override
    public void configure(CommandLineArgs cla) {
        super.configure(cla);
    }

    public static void validateCommandLineParameters(CommandLineArgs args) {
        TestNG.validateCommandLineParameters((CommandLineArgs)args);
    }

    public static String defaultIfStringEmpty(String s, String defaultValue) {
        return AbstractRemoteTestNG.isStringEmpty(s) ? defaultValue : s;
    }

    public static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    private void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IMessageSender sender = this.getMessageSender();
        MessageHub msh = new MessageHub(sender);
        msh.setDebug(this.m_debug);
        try {
            msh.connect();
            this.initializeSuitesAndJarFile();
            List suites = Lists.newArrayList();
            this.calculateAllSuites(this.m_suites, suites);
            if (suites.size() > 0) {
                int testCount = 0;
                for (XmlSuite suite : suites) {
                    testCount += suite.getTests().size();
                }
                GenericMessage gm = new GenericMessage(1);
                gm.setSuiteCount(suites.size());
                gm.setTestCount(testCount);
                msh.sendMessage(gm);
                this.addListener(new RemoteSuiteListener(msh));
                this.setTestRunnerFactory(this.createDelegatingTestRunnerFactory(this.buildTestRunnerFactory(), msh));
                super.run();
            } else {
                System.err.println("No test suite found. Nothing to run");
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
        finally {
            msh.shutDown();
            if (!this.m_debug && !this.m_dontExit) {
                System.exit(0);
            }
        }
    }

    private IMessageSender getMessageSender() {
        if (this.m_protocol != null) {
            switch (this.m_protocol) {
                case "object": {
                    return new SerializedMessageSender(this.m_host, this.m_serPort, this.m_ack);
                }
                case "string": {
                    return new StringMessageSender(this.m_host, this.m_port);
                }
                case "json": {
                    return new JsonMessageSender(this.m_host, this.m_serPort, this.m_ack);
                }
                case "stdout": {
                    return new StdoutMessageSender();
                }
            }
            throw new IllegalArgumentException("unrecognized protocol: " + this.m_protocol);
        }
        return this.m_serPort != null ? new SerializedMessageSender(this.m_host, this.m_serPort, this.m_ack) : new StringMessageSender(this.m_host, this.m_port);
    }

    protected abstract ITestRunnerFactory buildTestRunnerFactory();

    protected String getHost() {
        return this.m_host;
    }

    protected int getPort() {
        return this.m_port;
    }

    protected abstract ITestRunnerFactory createDelegatingTestRunnerFactory(ITestRunnerFactory var1, MessageHub var2);

    private static class RemoteSuiteListener
    implements ISuiteListener {
        private final MessageHub m_messageSender;

        RemoteSuiteListener(MessageHub smsh) {
            this.m_messageSender = smsh;
        }

        public void onFinish(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, false));
        }

        public void onStart(ISuite suite) {
            this.m_messageSender.sendMessage(new SuiteMessage(suite, true));
        }
    }
}

