/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.xml.IFileParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParser<T>
implements IFileParser<T> {
    private static final SAXParser m_saxParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, DefaultHandler defaultHandler) throws SAXException, IOException {
        SAXParser sAXParser = m_saxParser;
        synchronized (sAXParser) {
            m_saxParser.parse(inputStream, defaultHandler);
        }
    }

    private static SAXParserFactory loadSAXParserFactory() {
        Serializable serializable;
        SAXParserFactory sAXParserFactory = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            serializable = ClassHelper.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            sAXParserFactory = (SAXParserFactory)serializable.newInstance();
        }
        catch (Exception exception) {
            stringBuffer.append("JDK5 SAXParserFactory cannot be loaded: " + exception.getMessage());
        }
        if (null == sAXParserFactory) {
            try {
                serializable = ClassHelper.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                sAXParserFactory = (SAXParserFactory)serializable.newInstance();
            }
            catch (Exception exception) {
                stringBuffer.append("\n").append("JDK1.4 SAXParserFactory cannot be loaded: " + exception.getMessage());
            }
        }
        serializable = null;
        if (null == sAXParserFactory) {
            try {
                sAXParserFactory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                serializable = factoryConfigurationError;
            }
        }
        if (null == sAXParserFactory) {
            throw new TestNGException("Cannot initialize a SAXParserFactory\n" + stringBuffer.toString(), (Throwable)serializable);
        }
        return sAXParserFactory;
    }

    private static boolean supportsValidation(SAXParserFactory sAXParserFactory) {
        try {
            sAXParserFactory.getFeature("http://xml.org/sax/features/validation");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        SAXParserFactory sAXParserFactory = XMLParser.loadSAXParserFactory();
        if (XMLParser.supportsValidation(sAXParserFactory)) {
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
        }
        SAXParser sAXParser = null;
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
        }
        m_saxParser = sAXParser;
    }
}

