/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.SetMultiMap;
import org.testng.internal.Utils;
import org.testng.reporters.jq.ResultsByClass;

public class Model {
    private ListMultiMap<ISuite, ITestResult> m_model = Maps.newListMultiMap();
    private List<ISuite> m_suites = null;
    private Map<String, String> m_testTags = Maps.newHashMap();
    private Map<ITestResult, String> m_testResultMap = Maps.newHashMap();
    private Map<ISuite, ResultsByClass> m_failedResultsByClass = Maps.newHashMap();
    private Map<ISuite, ResultsByClass> m_skippedResultsByClass = Maps.newHashMap();
    private Map<ISuite, ResultsByClass> m_passedResultsByClass = Maps.newHashMap();
    private List<ITestResult> m_allFailedResults = Lists.newArrayList();
    private Map<String, String> m_statusBySuiteName = Maps.newHashMap();
    private SetMultiMap<String, String> m_groupsBySuiteName = Maps.newSetMultiMap();
    private SetMultiMap<String, String> m_methodsByGroup = Maps.newSetMultiMap();

    public Model(List<ISuite> list) {
        this.m_suites = list;
        this.init();
    }

    public List<ISuite> getSuites() {
        return this.m_suites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        int n = 0;
        for (ISuite iSuite : this.m_suites) {
            List<Serializable> list = Lists.newArrayList();
            List<Serializable> list2 = Lists.newArrayList();
            List<Serializable> list3 = Lists.newArrayList();
            Map<String, ISuiteResult> map = iSuite.getResults();
            Object object = map;
            synchronized (object) {
                for (ISuiteResult iSuiteResult : map.values()) {
                    IResultMap[] iResultMapArray;
                    ITestContext iTestContext = iSuiteResult.getTestContext();
                    this.m_testTags.put(iTestContext.getName(), "test-" + n++);
                    list2.addAll(iTestContext.getFailedTests().getAllResults());
                    list3.addAll(iTestContext.getSkippedTests().getAllResults());
                    list.addAll(iTestContext.getPassedTests().getAllResults());
                    for (IResultMap iResultMap : iResultMapArray = new IResultMap[]{iTestContext.getFailedTests(), iTestContext.getSkippedTests(), iTestContext.getPassedTests()}) {
                        for (ITestResult iTestResult : iResultMap.getAllResults()) {
                            this.m_testResultMap.put(iTestResult, Model.getTestResultName(iTestResult));
                        }
                    }
                }
            }
            object = new ResultsByClass();
            for (ITestResult iTestResult : list) {
                ((ResultsByClass)object).addResult(iTestResult.getTestClass().getRealClass(), iTestResult);
                this.updateGroups(iSuite, iTestResult);
            }
            this.m_passedResultsByClass.put(iSuite, (ResultsByClass)object);
            object = new ResultsByClass();
            for (ITestResult iTestResult : list3) {
                this.m_statusBySuiteName.put(iSuite.getName(), "skipped");
                ((ResultsByClass)object).addResult(iTestResult.getTestClass().getRealClass(), iTestResult);
                this.updateGroups(iSuite, iTestResult);
            }
            this.m_skippedResultsByClass.put(iSuite, (ResultsByClass)object);
            object = new ResultsByClass();
            for (ITestResult iTestResult : list2) {
                this.m_statusBySuiteName.put(iSuite.getName(), "failed");
                ((ResultsByClass)object).addResult(iTestResult.getTestClass().getRealClass(), iTestResult);
                this.m_allFailedResults.add(iTestResult);
                this.updateGroups(iSuite, iTestResult);
            }
            this.m_failedResultsByClass.put(iSuite, (ResultsByClass)object);
            this.m_model.putAll(iSuite, list2);
            this.m_model.putAll(iSuite, list3);
            this.m_model.putAll(iSuite, list);
        }
    }

    private void updateGroups(ISuite iSuite, ITestResult iTestResult) {
        String[] stringArray = iTestResult.getMethod().getGroups();
        this.m_groupsBySuiteName.putAll(iSuite.getName(), Arrays.asList(stringArray));
        for (String string : stringArray) {
            this.m_methodsByGroup.put(string, iTestResult.getMethod().getMethodName());
        }
    }

    public ResultsByClass getFailedResultsByClass(ISuite iSuite) {
        return this.m_failedResultsByClass.get(iSuite);
    }

    public ResultsByClass getSkippedResultsByClass(ISuite iSuite) {
        return this.m_skippedResultsByClass.get(iSuite);
    }

    public ResultsByClass getPassedResultsByClass(ISuite iSuite) {
        return this.m_passedResultsByClass.get(iSuite);
    }

    public String getTag(ITestResult iTestResult) {
        return this.m_testResultMap.get(iTestResult);
    }

    public List<ITestResult> getTestResults(ISuite iSuite) {
        return (List)this.m_model.get(iSuite);
    }

    public static String getTestResultName(ITestResult iTestResult) {
        StringBuilder stringBuilder = new StringBuilder(iTestResult.getMethod().getMethodName());
        Object[] objectArray = iTestResult.getParameters();
        if (objectArray.length > 0) {
            stringBuilder.append("(");
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(Utils.toString(objectArray[i]));
            }
            if (stringBuilder2.length() > 100) {
                String string = stringBuilder2.toString().substring(0, 100);
                string = string + "...";
                stringBuilder.append(string);
            } else {
                stringBuilder.append(stringBuilder2.toString());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public List<ITestResult> getAllFailedResults() {
        return this.m_allFailedResults;
    }

    public static String getImage(String string) {
        return string + ".png";
    }

    public String getStatusForSuite(String string) {
        String string2 = this.m_statusBySuiteName.get(string);
        return string2 != null ? string2 : "passed";
    }

    public List<String> getGroups(String string) {
        List<String> list = Lists.newArrayList(this.m_groupsBySuiteName.get(string));
        Collections.sort(list);
        return list;
    }

    public List<String> getMethodsInGroup(String string) {
        List<String> list = Lists.newArrayList(this.m_methodsByGroup.get(string));
        Collections.sort(list);
        return list;
    }

    public List<ITestResult> getAllTestResults(ISuite iSuite) {
        return this.getAllTestResults(iSuite, true);
    }

    public List<ITestResult> getAllTestResults(ISuite iSuite, boolean bl) {
        List<ITestResult> list = Lists.newArrayList();
        for (ISuiteResult iSuiteResult : iSuite.getResults().values()) {
            list.addAll(iSuiteResult.getTestContext().getPassedTests().getAllResults());
            list.addAll(iSuiteResult.getTestContext().getFailedTests().getAllResults());
            list.addAll(iSuiteResult.getTestContext().getSkippedTests().getAllResults());
            if (bl) continue;
            list.addAll(iSuiteResult.getTestContext().getPassedConfigurations().getAllResults());
            list.addAll(iSuiteResult.getTestContext().getFailedConfigurations().getAllResults());
            list.addAll(iSuiteResult.getTestContext().getSkippedConfigurations().getAllResults());
        }
        return list;
    }
}

