/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class Yaml {
    private static final String SP = "  ";

    public static XmlSuite parse(String string, InputStream inputStream) throws FileNotFoundException {
        TestNGConstructor testNGConstructor = new TestNGConstructor(XmlSuite.class);
        TypeDescription typeDescription = new TypeDescription(XmlSuite.class);
        typeDescription.putListPropertyType("packages", XmlPackage.class);
        typeDescription.putListPropertyType("listeners", String.class);
        typeDescription.putListPropertyType("tests", XmlTest.class);
        typeDescription.putListPropertyType("method-selectors", XmlMethodSelector.class);
        testNGConstructor.addTypeDescription(typeDescription);
        typeDescription = new TypeDescription(XmlTest.class);
        typeDescription.putListPropertyType("classes", XmlClass.class);
        typeDescription.putMapPropertyType("metaGroups", String.class, List.class);
        typeDescription.putListPropertyType("method-selectors", XmlMethodSelector.class);
        testNGConstructor.addTypeDescription(typeDescription);
        typeDescription = new org.yaml.snakeyaml.Yaml((BaseConstructor)testNGConstructor);
        if (inputStream == null) {
            inputStream = new FileInputStream(new File(string));
        }
        XmlSuite xmlSuite = (XmlSuite)typeDescription.load(inputStream);
        xmlSuite.setFileName(string);
        for (XmlTest xmlTest : xmlSuite.getTests()) {
            xmlTest.setSuite(xmlSuite);
            int n = 0;
            for (XmlClass xmlClass : xmlTest.getClasses()) {
                xmlClass.setIndex(n++);
            }
        }
        return xmlSuite;
    }

    private static void maybeAdd(StringBuilder stringBuilder, String string, Object object, Object object2) {
        Yaml.maybeAdd(stringBuilder, "", string, object, object2);
    }

    private static void maybeAdd(StringBuilder stringBuilder, String string, String string2, Object object, Object object2) {
        if (object != null && !object.equals(object2)) {
            stringBuilder.append(string).append(string2).append(": ").append(object.toString()).append("\n");
        }
    }

    public static StringBuilder toYaml(XmlSuite xmlSuite) {
        StringBuilder stringBuilder = new StringBuilder();
        Yaml.maybeAdd(stringBuilder, "name", xmlSuite.getName(), null);
        Yaml.maybeAdd(stringBuilder, "junit", xmlSuite.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(stringBuilder, "verbose", xmlSuite.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(stringBuilder, "threadCount", xmlSuite.getThreadCount(), XmlSuite.DEFAULT_THREAD_COUNT);
        Yaml.maybeAdd(stringBuilder, "dataProviderThreadCount", xmlSuite.getDataProviderThreadCount(), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT);
        Yaml.maybeAdd(stringBuilder, "timeOut", xmlSuite.getTimeOut(), null);
        Yaml.maybeAdd(stringBuilder, "parallel", (Object)xmlSuite.getParallel(), (Object)XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(stringBuilder, "skipFailedInvocationCounts", xmlSuite.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.toYaml(stringBuilder, "parameters", "", xmlSuite.getParameters());
        Yaml.toYaml(stringBuilder, xmlSuite.getPackages());
        if (xmlSuite.getListeners().size() > 0) {
            stringBuilder.append("listeners:\n");
            Yaml.toYaml(stringBuilder, SP, xmlSuite.getListeners());
        }
        if (xmlSuite.getPackages().size() > 0) {
            stringBuilder.append("packages:\n");
            Yaml.toYaml(stringBuilder, xmlSuite.getPackages());
        }
        if (xmlSuite.getTests().size() > 0) {
            stringBuilder.append("tests:\n");
            for (XmlTest xmlTest : xmlSuite.getTests()) {
                Yaml.toYaml(stringBuilder, SP, xmlTest);
            }
        }
        if (xmlSuite.getChildSuites().size() > 0) {
            stringBuilder.append("suite-files:\n");
            Yaml.toYaml(stringBuilder, SP, xmlSuite.getSuiteFiles());
        }
        return stringBuilder;
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlTest xmlTest) {
        Map<String, List<String>> map;
        String string2 = string + SP;
        stringBuilder.append(string).append("- name: ").append(xmlTest.getName()).append("\n");
        Yaml.maybeAdd(stringBuilder, string2, "junit", xmlTest.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(stringBuilder, string2, "verbose", xmlTest.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(stringBuilder, string2, "timeOut", xmlTest.getTimeOut(), null);
        Yaml.maybeAdd(stringBuilder, string2, "parallel", (Object)xmlTest.getParallel(), (Object)XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(stringBuilder, string2, "skipFailedInvocationCounts", xmlTest.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.maybeAdd(stringBuilder, "preserveOrder", string2, xmlTest.getPreserveOrder(), XmlSuite.DEFAULT_PRESERVE_ORDER);
        Yaml.toYaml(stringBuilder, "parameters", string2, xmlTest.getLocalParameters());
        if (xmlTest.getIncludedGroups().size() > 0) {
            stringBuilder.append(string2).append("includedGroups: [ ").append(Utils.join(xmlTest.getIncludedGroups(), ",")).append(" ]\n");
        }
        if (xmlTest.getExcludedGroups().size() > 0) {
            stringBuilder.append(string2).append("excludedGroups: [ ").append(Utils.join(xmlTest.getExcludedGroups(), ",")).append(" ]\n");
        }
        if ((map = xmlTest.getMetaGroups()).size() > 0) {
            stringBuilder.append(string2).append("metaGroups: { ");
            boolean bl = true;
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(entry.getKey()).append(": [ ").append(Utils.join(entry.getValue(), ",")).append(" ] ");
                bl = false;
            }
            stringBuilder.append(" }\n");
        }
        if (xmlTest.getXmlPackages().size() > 0) {
            stringBuilder.append(string2).append("xmlPackages:\n");
            for (XmlPackage xmlPackage : xmlTest.getXmlPackages()) {
                Yaml.toYaml(stringBuilder, string2 + "  - ", xmlPackage);
            }
        }
        if (xmlTest.getXmlClasses().size() > 0) {
            stringBuilder.append(string2).append("classes:\n");
            for (XmlClass xmlClass : xmlTest.getXmlClasses()) {
                Yaml.toYaml(stringBuilder, string2 + SP, xmlClass);
            }
        }
        stringBuilder.append("\n");
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlClass xmlClass) {
        List<XmlInclude> list = xmlClass.getIncludedMethods();
        List<String> list2 = xmlClass.getExcludedMethods();
        String string2 = list.size() > 0 || list2.size() > 0 ? "name: " : "";
        stringBuilder.append(string).append("- " + string2).append(xmlClass.getName()).append("\n");
        if (list.size() > 0) {
            stringBuilder.append(string + "  includedMethods:\n");
            for (XmlInclude xmlInclude : list) {
                Yaml.toYaml(stringBuilder, string + "    ", xmlInclude);
            }
        }
        if (list2.size() > 0) {
            stringBuilder.append(string + "  excludedMethods:\n");
            Yaml.toYaml(stringBuilder, string + "    ", list2);
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlInclude xmlInclude) {
        stringBuilder.append(string + "- " + xmlInclude.getName()).append("\n");
    }

    private static void toYaml(StringBuilder stringBuilder, String string, List<String> list) {
        for (String string2 : list) {
            stringBuilder.append(string).append("- ").append(string2).append("\n");
        }
    }

    private static void toYaml(StringBuilder stringBuilder, List<XmlPackage> list) {
        if (list.size() > 0) {
            stringBuilder.append("packages:\n");
            for (XmlPackage xmlPackage : list) {
                Yaml.toYaml(stringBuilder, SP, xmlPackage);
            }
        }
        for (XmlPackage xmlPackage : list) {
            Yaml.toYaml(stringBuilder, SP, xmlPackage);
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, XmlPackage xmlPackage) {
        stringBuilder.append(string).append("name: ").append(xmlPackage.getName()).append("\n");
        Yaml.generateIncludeExclude(stringBuilder, string, "includes", xmlPackage.getInclude());
        Yaml.generateIncludeExclude(stringBuilder, string, "excludes", xmlPackage.getExclude());
    }

    private static void generateIncludeExclude(StringBuilder stringBuilder, String string, String string2, List<String> list) {
        if (list.size() > 0) {
            stringBuilder.append(string).append(SP).append(string2).append("\n");
            for (String string3 : list) {
                stringBuilder.append(string).append("    ").append(string3);
            }
        }
    }

    private static void mapToYaml(Map<String, String> map, StringBuilder stringBuilder) {
        if (map.size() > 0) {
            stringBuilder.append("{ ");
            boolean bl = true;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(entry.getKey() + ": " + entry.getValue());
            }
            stringBuilder.append(" }\n");
        }
    }

    private static void toYaml(StringBuilder stringBuilder, String string, String string2, Map<String, String> map) {
        if (map.size() > 0) {
            stringBuilder.append(string2).append(string).append(": ");
            Yaml.mapToYaml(map, stringBuilder);
        }
    }

    private static class TestNGConstructor
    extends Constructor {
        public TestNGConstructor(Class<? extends Object> clazz) {
            super(clazz);
            this.yamlClassConstructors.put(NodeId.scalar, new ConstructParallelMode());
        }

        private class ConstructParallelMode
        extends Constructor.ConstructScalar {
            private ConstructParallelMode() {
                super((Constructor)TestNGConstructor.this);
            }

            public Object construct(Node node) {
                if (node.getType().equals(XmlSuite.ParallelMode.class)) {
                    String string = (String)TestNGConstructor.this.constructScalar((ScalarNode)node);
                    return XmlSuite.ParallelMode.getValidParallel(string);
                }
                return super.construct(node);
            }
        }
    }
}

