/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodGroupsHelper {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    static void collectMethodsByGroup(ITestNGMethod[] iTestNGMethodArray, boolean bl, List<ITestNGMethod> list, List<ITestNGMethod> list2, RunInfo runInfo, IAnnotationFinder iAnnotationFinder, boolean bl2) {
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            boolean bl3 = false;
            Method method = iTestNGMethod.getMethod();
            if (bl) {
                bl3 = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(iAnnotationFinder, method), runInfo, iTestNGMethod, bl, bl2, list);
            } else {
                IConfigurationAnnotation iConfigurationAnnotation = AnnotationHelper.findConfiguration(iAnnotationFinder, method);
                if (iConfigurationAnnotation.getAlwaysRun()) {
                    if (!bl2 || !MethodGroupsHelper.isMethodAlreadyPresent(list, iTestNGMethod)) {
                        bl3 = true;
                    }
                } else {
                    bl3 = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(iAnnotationFinder, iTestNGMethod), runInfo, iTestNGMethod, bl, bl2, list);
                }
            }
            if (bl3) {
                list.add(iTestNGMethod);
                continue;
            }
            list2.add(iTestNGMethod);
        }
    }

    private static boolean includeMethod(ITestOrConfiguration iTestOrConfiguration, RunInfo runInfo, ITestNGMethod iTestNGMethod, boolean bl, boolean bl2, List<ITestNGMethod> list) {
        boolean bl3 = false;
        if (MethodHelper.isEnabled(iTestOrConfiguration) && runInfo.includeMethod(iTestNGMethod, bl)) {
            if (bl2) {
                if (!MethodGroupsHelper.isMethodAlreadyPresent(list, iTestNGMethod)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        }
        return bl3;
    }

    private static boolean isMethodAlreadyPresent(List<ITestNGMethod> list, ITestNGMethod iTestNGMethod) {
        for (ITestNGMethod iTestNGMethod2 : list) {
            Class<?> clazz;
            Class<?> clazz2;
            Method method = iTestNGMethod2.getMethod();
            Method method2 = iTestNGMethod.getMethod();
            if (!method.getName().equals(method2.getName()) || !(clazz2 = method.getDeclaringClass()).isAssignableFrom(clazz = method2.getDeclaringClass()) && !clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> collection, boolean bl) {
        Map<String, List<ITestNGMethod>> map = Maps.newHashMap();
        for (ITestClass iTestClass : collection) {
            ITestNGMethod[] iTestNGMethodArray;
            for (ITestNGMethod iTestNGMethod : iTestNGMethodArray = bl ? iTestClass.getBeforeGroupsMethods() : iTestClass.getAfterGroupsMethods()) {
                for (String string : bl ? iTestNGMethod.getBeforeGroups() : iTestNGMethod.getAfterGroups()) {
                    List<ITestNGMethod> list = map.get(string);
                    if (list == null) {
                        list = Lists.newArrayList();
                        map.put(string, list);
                    }
                    if (list.contains(iTestNGMethod)) continue;
                    list.add(iTestNGMethod);
                }
            }
        }
        return map;
    }

    protected static void findGroupTransitiveClosure(XmlMethodSelector xmlMethodSelector, List<ITestNGMethod> list, List<ITestNGMethod> list2, String[] stringArray, Set<String> set, Set<ITestNGMethod> set2) {
        boolean bl;
        Map<Object, Object> map = Maps.newHashMap();
        for (ITestNGMethod stringArray2 : list) {
            map.put(stringArray2, stringArray2);
        }
        Map map2 = Maps.newHashMap();
        for (String string : stringArray) {
            map2.put(string, string);
        }
        boolean bl2 = true;
        Map<Object, Object> map3 = Maps.newHashMap();
        while (bl) {
            for (ITestNGMethod iTestNGMethod : list) {
                ITestNGMethod[] iTestNGMethodArray;
                int n;
                String[] stringArray2;
                String[] stringArray3 = stringArray2 = iTestNGMethod.getGroupsDependedUpon();
                int n2 = stringArray3.length;
                for (n = 0; n < n2; ++n) {
                    String string = stringArray3[n];
                    if (map2.containsKey(string)) continue;
                    map2.put(string, string);
                    for (ITestNGMethod iTestNGMethod2 : iTestNGMethodArray = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethod, list2.toArray(new ITestNGMethod[list2.size()]), string)) {
                        if (map.containsKey(iTestNGMethod2)) continue;
                        map.put(iTestNGMethod2, iTestNGMethod2);
                        map3.put(iTestNGMethod2, iTestNGMethod2);
                    }
                }
                String[] stringArray4 = stringArray3 = iTestNGMethod.getMethodsDependedUpon();
                n = stringArray4.length;
                for (int i = 0; i < n; ++i) {
                    iTestNGMethodArray = stringArray4[i];
                    ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodNamed((String)iTestNGMethodArray, list2);
                    if (iTestNGMethodArray2 == null || map.containsKey(iTestNGMethodArray2)) continue;
                    map.put(iTestNGMethodArray2, iTestNGMethodArray2);
                    map3.put(iTestNGMethodArray2, iTestNGMethodArray2);
                }
            }
            bl = map3.size() > 0;
            list = Lists.newArrayList();
            list.addAll(map3.keySet());
            map3 = Maps.newHashMap();
        }
        set2.addAll(map.keySet());
        set.addAll(map2.keySet());
    }

    private static ITestNGMethod findMethodNamed(String string, List<ITestNGMethod> list) {
        for (ITestNGMethod iTestNGMethod : list) {
            String string2 = iTestNGMethod.getQualifiedName();
            if (!string2.equals(string)) continue;
            return iTestNGMethod;
        }
        return null;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod iTestNGMethod, ITestNGMethod[] iTestNGMethodArray, String string) {
        ITestNGMethod[] iTestNGMethodArray2 = MethodGroupsHelper.findMethodsThatBelongToGroup(iTestNGMethodArray, string);
        if (iTestNGMethodArray2.length == 0) {
            iTestNGMethod.setMissingGroup(string);
        }
        return iTestNGMethodArray2;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod[] iTestNGMethodArray, String string) {
        List list = Lists.newArrayList();
        Pattern pattern = MethodGroupsHelper.getPattern(string);
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            String[] stringArray;
            for (String string2 : stringArray = iTestNGMethod.getGroups()) {
                Boolean bl = MethodGroupsHelper.isMatch(pattern, string2);
                if (!bl.booleanValue()) continue;
                list.add(iTestNGMethod);
            }
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    private static Boolean isMatch(Pattern pattern, String string) {
        Pair<String, String> pair = Pair.create(pattern.pattern(), string);
        Boolean bl = MATCH_CACHE.get(pair);
        if (bl == null) {
            bl = pattern.matcher(string).matches();
            MATCH_CACHE.put(pair, bl);
        }
        return bl;
    }

    private static Pattern getPattern(String string) {
        Pattern pattern = PATTERN_CACHE.get(string);
        if (pattern == null) {
            pattern = Pattern.compile(string);
            PATTERN_CACHE.put(string, pattern);
        }
        return pattern;
    }
}

