/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import java.util.Properties;
import org.testng.collections.Maps;
import org.testng.internal.TestNGProperty;

public class Constants {
    private static final String NAMESPACE = "testng";
    public static final String PROP_OUTPUT_DIR = "testng.outputDir";
    private static final TestNGProperty[] COMMAND_LINE_PARAMETERS = new TestNGProperty[]{new TestNGProperty("-d", "testng.outputDir", "Directory where the result files will be created.", "test-output")};
    private static final Map<String, TestNGProperty> m_propertiesByName = Maps.newHashMap();

    private static TestNGProperty getProperty(String string) {
        TestNGProperty testNGProperty = m_propertiesByName.get(string);
        assert (null != testNGProperty) : "Unknown property : " + string;
        return testNGProperty;
    }

    public static String getPropertyValue(Properties properties, String string) {
        TestNGProperty testNGProperty = Constants.getProperty(string);
        assert (null != testNGProperty) : "Unknown property : " + string;
        String string2 = properties.getProperty(testNGProperty.getName());
        return string2;
    }

    public static boolean getBooleanPropertyValue(Properties properties, String string) {
        TestNGProperty testNGProperty = Constants.getProperty(string);
        String string2 = properties.getProperty(string, testNGProperty.getDefault());
        boolean bl = "true".equalsIgnoreCase(string2);
        return bl;
    }

    public static int getIntegerPropertyValue(Properties properties, String string) {
        TestNGProperty testNGProperty = Constants.getProperty(string);
        String string2 = properties.getProperty(string, testNGProperty.getDefault());
        int n = Integer.parseInt(string2);
        return n;
    }

    public static String getDefaultValueFor(String string) {
        TestNGProperty testNGProperty = Constants.getProperty(string);
        return testNGProperty.getDefault();
    }

    public static String displayStatus(int n) {
        if (3 == n) {
            return "SKIP";
        }
        if (1 == n) {
            return "SUCCESS";
        }
        if (2 == n) {
            return "FAILURE";
        }
        return "UNKNOWN_STATUS";
    }

    static {
        for (TestNGProperty testNGProperty : COMMAND_LINE_PARAMETERS) {
            m_propertiesByName.put(testNGProperty.getName(), testNGProperty);
        }
    }
}

