/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.testng.IMethodSelector;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.DefaultMethodSelectorContext;
import org.testng.internal.MethodSelectorDescriptor;
import org.testng.internal.Utils;

public class RunInfo
implements Serializable {
    private static final long serialVersionUID = -9085221672822562888L;
    private transient List<MethodSelectorDescriptor> m_methodSelectors = Lists.newArrayList();

    public void addMethodSelector(IMethodSelector iMethodSelector, int n) {
        Utils.log("RunInfo", 3, "Adding method selector: " + iMethodSelector + " priority: " + n);
        MethodSelectorDescriptor methodSelectorDescriptor = new MethodSelectorDescriptor(iMethodSelector, n);
        this.m_methodSelectors.add(methodSelectorDescriptor);
    }

    public boolean includeMethod(ITestNGMethod iTestNGMethod, boolean bl) {
        Collections.sort(this.m_methodSelectors);
        boolean bl2 = false;
        DefaultMethodSelectorContext defaultMethodSelectorContext = new DefaultMethodSelectorContext();
        boolean bl3 = false;
        for (MethodSelectorDescriptor methodSelectorDescriptor : this.m_methodSelectors) {
            if (!bl2) {
                boolean bl4 = bl2 = methodSelectorDescriptor.getPriority() < 0;
            }
            if (bl2 && methodSelectorDescriptor.getPriority() >= 0) break;
            IMethodSelector iMethodSelector = methodSelectorDescriptor.getMethodSelector();
            bl3 = iMethodSelector.includeMethod(defaultMethodSelectorContext, iTestNGMethod, bl);
            if (!defaultMethodSelectorContext.isStopped()) continue;
            return bl3;
        }
        return bl3;
    }

    public static void ppp(String string) {
        System.out.println("[RunInfo] " + string);
    }

    public void setTestMethods(List<ITestNGMethod> list) {
        for (MethodSelectorDescriptor methodSelectorDescriptor : this.m_methodSelectors) {
            methodSelectorDescriptor.setTestMethods(list);
        }
    }
}

