/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.testng.collections.Lists;
import org.testng.internal.Utils;

public class PackageUtils {
    private static String[] s_testClassPaths;
    private static final List<ClassLoader> m_classLoaders;

    public static void addClassLoader(ClassLoader classLoader) {
        m_classLoaders.add(classLoader);
    }

    public static String[] findClassesInPackage(String string, List<String> list, List<String> list2) throws IOException {
        Class[] classArray;
        Object object;
        String string2 = string;
        boolean bl = false;
        if (string.endsWith(".*")) {
            string2 = string.substring(0, string.lastIndexOf(".*"));
            bl = true;
        }
        List<String> list3 = Lists.newArrayList();
        String string3 = string2.replace('.', '/') + (string2.length() > 0 ? "/" : "");
        Vector<URL> vector = new Vector<URL>();
        Vector<ClassLoader> vector2 = new Vector<ClassLoader>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            vector2.add(classLoader);
        }
        if (m_classLoaders != null) {
            vector2.addAll(m_classLoaders);
        }
        int n = 0;
        for (ClassLoader stringArray2 : vector2) {
            ++n;
            if (null == stringArray2) continue;
            object = stringArray2.getResources(string3);
            while (object.hasMoreElements()) {
                classArray = (URL)object.nextElement();
                vector.add((URL)classArray);
            }
        }
        for (URL uRL : vector) {
            Object object2;
            Object object3;
            Object object4;
            object = uRL.getProtocol();
            if (!PackageUtils.matchTestClasspath(uRL, string3, bl)) continue;
            if ("file".equals(object)) {
                PackageUtils.findClassesInDirPackage(string2, list, list2, URLDecoder.decode(uRL.getFile(), "UTF-8"), bl, list3);
                continue;
            }
            if ("jar".equals(object)) {
                classArray = ((JarURLConnection)uRL.openConnection()).getJarFile();
                object4 = classArray.entries();
                while (object4.hasMoreElements()) {
                    object3 = (JarEntry)object4.nextElement();
                    object2 = ((ZipEntry)object3).getName();
                    if (((String)object2).charAt(0) == '/') {
                        object2 = ((String)object2).substring(1);
                    }
                    if (!((String)object2).startsWith(string3)) continue;
                    int n2 = ((String)object2).lastIndexOf(47);
                    if (n2 != -1) {
                        string = ((String)object2).substring(0, n2).replace('/', '.');
                    }
                    if (!bl && !string.equals(string2)) continue;
                    Utils.log("PackageUtils", 4, "Package name is " + string);
                    if (!((String)object2).endsWith(".class") || ((ZipEntry)object3).isDirectory()) continue;
                    String string4 = ((String)object2).substring(string.length() + 1, ((String)object2).length() - 6);
                    Utils.log("PackageUtils", 4, "Found class " + string4 + ", seeing it if it's included or excluded");
                    PackageUtils.includeOrExcludeClass(string, string4, list, list2, list3);
                }
                continue;
            }
            if (!"bundleresource".equals(object)) continue;
            try {
                classArray = new Class[]{};
                object4 = uRL.openConnection();
                object3 = uRL.openConnection().getClass().getDeclaredMethod("getFileURL", classArray);
                object2 = new Object[]{};
                URL uRL2 = (URL)((Method)object3).invoke(object4, (Object[])object2);
                PackageUtils.findClassesInDirPackage(string2, list, list2, URLDecoder.decode(uRL2.getFile(), "UTF-8"), bl, list3);
            }
            catch (Exception exception) {
            }
        }
        String[] stringArray = list3.toArray(new String[list3.size()]);
        return stringArray;
    }

    private static String[] getTestClasspath() {
        if (null != s_testClassPaths) {
            return s_testClassPaths;
        }
        String string = System.getProperty("testng.test.classpath");
        if (null == string) {
            return null;
        }
        String[] stringArray = Utils.split(string, File.pathSeparator);
        s_testClassPaths = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = null;
            string2 = stringArray[i].toLowerCase().endsWith(".jar") || stringArray[i].toLowerCase().endsWith(".zip") ? stringArray[i] + "!/" : (stringArray[i].endsWith(File.separator) ? stringArray[i] : stringArray[i] + "/");
            PackageUtils.s_testClassPaths[i] = string2.replace('\\', '/');
        }
        return s_testClassPaths;
    }

    private static boolean matchTestClasspath(URL uRL, String string, boolean bl) {
        String[] stringArray = PackageUtils.getTestClasspath();
        if (null == stringArray) {
            return true;
        }
        String string2 = null;
        try {
            string2 = URLDecoder.decode(uRL.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (String string3 : stringArray) {
            String string4 = string3 + string;
            int n = string2.indexOf(string4);
            if (n == -1 || n > 0 && string2.charAt(n - 1) != '/' || !string2.endsWith(string3 + string) && (!bl || string2.charAt(n + string4.length()) != '/')) continue;
            return true;
        }
        return false;
    }

    private static void findClassesInDirPackage(String string, List<String> list, List<String> list2, String string2, final boolean bl, List<String> list3) {
        File file = new File(string2);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return bl && file.isDirectory() || file.getName().endsWith(".class") || file.getName().endsWith(".groovy");
            }
        });
        Utils.log("PackageUtils", 4, "Looking for test classes in the directory: " + file);
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                PackageUtils.findClassesInDirPackage(PackageUtils.makeFullClassName(string, file2.getName()), list, list2, file2.getAbsolutePath(), bl, list3);
                continue;
            }
            String string3 = file2.getName().substring(0, file2.getName().lastIndexOf("."));
            Utils.log("PackageUtils", 4, "Found class " + string3 + ", seeing it if it's included or excluded");
            PackageUtils.includeOrExcludeClass(string, string3, list, list2, list3);
        }
    }

    private static String makeFullClassName(String string, String string2) {
        return string.length() > 0 ? string + "." + string2 : string2;
    }

    private static void includeOrExcludeClass(String string, String string2, List<String> list, List<String> list2, List<String> list3) {
        if (PackageUtils.isIncluded(string, list, list2)) {
            Utils.log("PackageUtils", 4, "... Including class " + string2);
            list3.add(PackageUtils.makeFullClassName(string, string2));
        } else {
            Utils.log("PackageUtils", 4, "... Excluding class " + string2);
        }
    }

    private static boolean isIncluded(String string, List<String> list, List<String> list2) {
        boolean bl = false;
        if (list.size() == 0 && list2.size() == 0) {
            bl = true;
        } else {
            boolean bl2 = PackageUtils.find(string, list);
            boolean bl3 = PackageUtils.find(string, list2);
            bl = bl2 && !bl3 ? true : (bl3 ? false : list.size() == 0);
        }
        return bl;
    }

    private static boolean find(String string, List<String> list) {
        for (String string2 : list) {
            if (!Pattern.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    static {
        m_classLoaders = new Vector<ClassLoader>();
    }
}

