/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.collections.Pair;

public class DynamicGraph<T> {
    private final List<T> m_nodesReady = Lists.newArrayList();
    private final List<T> m_nodesRunning = Lists.newArrayList();
    private final List<T> m_nodesFinished = Lists.newArrayList();
    private final ListMultiMap<T, Edge<T>> m_edges = Maps.newListMultiMap();

    public void addNode(T t) {
        this.m_nodesReady.add(t);
    }

    public void addEdge(int n, T t, T ... TArray) {
        this.addEdge(n, t, (Iterable<T>)Arrays.asList(TArray));
    }

    public void addEdge(int n, T t, Iterable<T> iterable) {
        List<Edge<T>> list = Lists.newArrayList();
        for (T t2 : iterable) {
            list.add(new Edge(t, t2, n));
        }
        this.addEdges(list);
    }

    private void addEdges(List<Edge<T>> list) {
        for (Edge<T> edge : list) {
            Edge<T> edge2 = DynamicGraph.getNode(this.m_edges, edge);
            if (edge2 != null && ((Edge)edge2).weight == ((Edge)edge).weight) {
                throw new IllegalStateException("Circular dependency: " + ((Edge)edge).from + " <-> " + ((Edge)edge).to);
            }
            if (edge2 == null) {
                this.m_edges.put(((Edge)edge).from, edge);
                continue;
            }
            if (((Edge)edge2).weight >= ((Edge)edge).weight) continue;
            this.m_edges.put(((Edge)edge).from, edge);
        }
    }

    private static <T> Edge<T> getNode(ListMultiMap<T, Edge<T>> listMultiMap, Edge<T> edge) {
        for (Edge edge2 : (List)listMultiMap.get(((Edge)edge).to)) {
            if (!edge2.to.equals(((Edge)edge).from)) continue;
            return edge2;
        }
        return null;
    }

    public List<T> getFreeNodes() {
        List list = Lists.newArrayList();
        for (Object object : this.m_nodesReady) {
            if (!((List)this.m_edges.get(object)).isEmpty() && !this.getUnfinishedNodes(object).isEmpty()) continue;
            list.add(object);
        }
        if (list.isEmpty()) {
            int n = this.getLowestEdgePriority(this.m_nodesReady);
            for (Object e : this.m_nodesReady) {
                if (!DynamicGraph.hasAllEdgesWithLevel((List)this.m_edges.get(e), n)) continue;
                list.add(e);
            }
        }
        return list;
    }

    private int getLowestEdgePriority(List<T> list) {
        if (list.isEmpty()) {
            return 0;
        }
        Integer n = null;
        for (T t : list) {
            for (Edge edge : (List)this.m_edges.get(t)) {
                if (n == null) {
                    n = edge.weight;
                    continue;
                }
                n = n < edge.weight ? n : edge.weight;
            }
        }
        return n == null ? 0 : n;
    }

    private static <T> boolean hasAllEdgesWithLevel(List<Edge<T>> list, int n) {
        for (Edge<T> edge : list) {
            if (((Edge)edge).weight == n) continue;
            return false;
        }
        return true;
    }

    private Collection<? extends T> getUnfinishedNodes(T t) {
        Set set = Sets.newHashSet();
        for (Edge edge : (List)this.m_edges.get(t)) {
            if (!this.m_nodesReady.contains(edge.to) && !this.m_nodesRunning.contains(edge.to)) continue;
            set.add(edge.to);
        }
        return set;
    }

    public void setStatus(Collection<T> collection, Status status) {
        for (T t : collection) {
            this.setStatus(t, status);
        }
    }

    public void setStatus(T t, Status status) {
        switch (status) {
            case RUNNING: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.add(t);
                break;
            }
            case FINISHED: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.remove(t);
                this.m_nodesFinished.add(t);
                this.m_edges.removeAll(t);
                List<Object> list = Lists.newArrayList();
                for (Map.Entry object : this.m_edges.entrySet()) {
                    for (Edge edge : (List)object.getValue()) {
                        if (!edge.to.equals(t)) continue;
                        list.add(new Pair(object.getKey(), edge));
                    }
                }
                for (Pair pair : list) {
                    this.m_edges.remove((T)pair.first(), (Edge<T>)pair.second());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status: " + (Object)((Object)status));
            }
        }
    }

    public int getNodeCount() {
        int n = this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
        return n;
    }

    public int getNodeCountWithStatus(Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady.size();
            }
            case RUNNING: {
                return this.m_nodesRunning.size();
            }
            case FINISHED: {
                return this.m_nodesFinished.size();
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[DynamicGraph ");
        stringBuilder.append("\n  Ready:" + this.m_nodesReady);
        stringBuilder.append("\n  Running:" + this.m_nodesRunning);
        stringBuilder.append("\n  Finished:" + this.m_nodesFinished);
        stringBuilder.append("\n  Edges:\n");
        for (Map.Entry entry : this.m_edges.entrySet()) {
            stringBuilder.append("     " + entry.getKey() + "\n");
            for (Edge edge : (List)entry.getValue()) {
                stringBuilder.append("        " + edge.to + "\n");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String getName(T t) {
        String string = t.toString();
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.indexOf(40);
        return string.substring(n, n2);
    }

    public String toDot() {
        String string;
        String string2 = "[style=filled color=yellow]";
        String string3 = "[style=filled color=green]";
        String string4 = "[style=filled color=grey]";
        StringBuilder stringBuilder = new StringBuilder("digraph g {\n");
        List<T> list = this.getFreeNodes();
        for (Object object : this.m_nodesReady) {
            string = list.contains(object) ? string2 : "";
            stringBuilder.append("  " + this.getName(object) + string + "\n");
        }
        for (Object object : this.m_nodesRunning) {
            string = list.contains(object) ? string2 : string3;
            stringBuilder.append("  " + this.getName(object) + string + "\n");
        }
        for (Object object : this.m_nodesFinished) {
            stringBuilder.append("  " + this.getName(object) + string4 + "\n");
        }
        stringBuilder.append("\n");
        for (Object object : this.m_edges.values()) {
            for (Edge edge : object) {
                String string5 = this.m_nodesFinished.contains(edge.from) ? "style=dotted" : "";
                stringBuilder.append("  " + this.getName(edge.from) + " -> " + this.getName(edge.to) + " [dir=back " + string5 + "]\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public ListMultiMap<T, Edge<T>> getEdges() {
        return this.m_edges;
    }

    private static class Edge<T> {
        private final T from;
        private final T to;
        private int weight;

        private Edge(T t, T t2, int n) {
            this.from = t;
            this.to = t2;
            this.weight = n;
        }
    }

    public static enum Status {
        READY,
        RUNNING,
        FINISHED;

    }
}

