/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;

public class ConfigurationGroupMethods
implements Serializable {
    private static final long serialVersionUID = 1660798519864898480L;
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] iTestNGMethodArray, Map<String, List<ITestNGMethod>> map, Map<String, List<ITestNGMethod>> map2) {
        this.m_allMethods = iTestNGMethodArray;
        this.m_beforeGroupsMethods = map;
        this.m_afterGroupsMethods = map2;
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    public synchronized boolean isLastMethodForGroup(String string, ITestNGMethod iTestNGMethod) {
        List<ITestNGMethod> list;
        if (iTestNGMethod.hasMoreInvocation()) {
            return false;
        }
        if (this.m_afterGroupsMap == null) {
            this.m_afterGroupsMap = this.initializeAfterGroupsMap();
        }
        if (null == (list = this.m_afterGroupsMap.get(string)) || list.isEmpty()) {
            return false;
        }
        list.remove(iTestNGMethod);
        return list.isEmpty();
    }

    private synchronized Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map<String, List<ITestNGMethod>> map = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : this.m_allMethods) {
            String[] stringArray;
            for (String string : stringArray = iTestNGMethod.getGroups()) {
                List<ITestNGMethod> list = map.get(string);
                if (null == list) {
                    list = Lists.newArrayList();
                    map.put(string, list);
                }
                list.add(iTestNGMethod);
            }
        }
        return map;
    }

    public synchronized void removeBeforeMethod(String string, ITestNGMethod iTestNGMethod) {
        List<ITestNGMethod> list = this.m_beforeGroupsMethods.get(string);
        if (list != null) {
            Boolean bl = list.remove(iTestNGMethod);
            if (bl == null) {
                this.log("Couldn't remove beforeGroups method " + iTestNGMethod + " for group " + string);
            }
        } else {
            this.log("Couldn't find any beforeGroups method for group " + string);
        }
    }

    private void log(String string) {
        Utils.log("ConfigurationGroupMethods", 2, string);
    }

    public synchronized Map<String, List<ITestNGMethod>> getBeforeGroupsMap() {
        return this.m_beforeGroupsMethods;
    }

    public synchronized Map<String, List<ITestNGMethod>> getAfterGroupsMap() {
        return this.m_afterGroupsMethods;
    }

    public synchronized void removeBeforeGroups(String[] stringArray) {
        for (String string : stringArray) {
            this.m_beforeGroupsMethods.remove(string);
        }
    }

    public synchronized void removeAfterGroups(Collection<String> collection) {
        for (String string : collection) {
            this.m_afterGroupsMethods.remove(string);
        }
    }
}

