/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.strprotocol.BaseMessageSender;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IMessage;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;
import org.testng.shaded.com.google.gson.Gson;
import org.testng.shaded.com.google.gson.GsonBuilder;
import org.testng.shaded.com.google.gson.stream.JsonReader;
import org.testng.shaded.com.google.gson.stream.JsonWriter;

public class JsonMessageSender
extends BaseMessageSender {
    public JsonMessageSender(String host, int port) {
        super(host, port, false);
    }

    public JsonMessageSender(String host, int port, boolean ack) {
        super(host, port, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(IMessage message) throws Exception {
        if (this.m_outStream == null) {
            throw new IllegalStateException("Trying to send a message on a shutdown sender");
        }
        OutputStream outputStream = this.m_outStream;
        synchronized (outputStream) {
            JsonMessageSender.p("Sending message " + message);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.m_outStream, "UTF-8"));
            JsonWriter writer = new JsonWriter(bw);
            this.writeMessage(writer, message);
            bw.newLine();
            bw.flush();
            this.waitForAck();
        }
    }

    void writeMessage(JsonWriter writer, IMessage message) throws IOException {
        writer.beginObject();
        int messageType = this.getMessageType(message);
        if (messageType < 0) {
            throw new IOException("Unknown type for message: " + message);
        }
        writer.name("type").value(messageType);
        writer.name("data");
        Gson gson = new GsonBuilder().create();
        gson.toJson((Object)message, message.getClass(), writer);
        writer.endObject();
    }

    private int getMessageType(IMessage message) {
        if (message instanceof GenericMessage) {
            return 1;
        }
        if (message instanceof SuiteMessage) {
            return 10;
        }
        if (message instanceof TestMessage) {
            return 100;
        }
        if (message instanceof TestResultMessage) {
            return 1000;
        }
        return -1;
    }

    @Override
    public IMessage receiveMessage() throws Exception {
        IMessage message;
        block6: {
            if (this.m_inReader == null) {
                try {
                    this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream));
                }
            }
            String msg = this.m_inReader.readLine();
            JsonMessageSender.p("received message: " + msg);
            message = null;
            if (msg != null) {
                message = this.deserializeMessage(msg);
            }
            try {
                this.sendAck();
            }
            catch (Exception e) {
                if (!RemoteTestNG.isVerbose()) break block6;
                System.out.println("sendAck failed with error: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return message;
    }

    IMessage deserializeMessage(String jsonMsg) throws IOException {
        try (JsonReader reader = new JsonReader(new StringReader(jsonMsg));){
            reader.beginObject();
            String name = reader.nextName();
            if (!"type".equals(name)) {
                throw new IOException("type node first");
            }
            int msgType = reader.nextInt();
            name = reader.nextName();
            if (!"data".equals(name)) {
                throw new IOException("data node then");
            }
            Gson gson = new GsonBuilder().create();
            IMessage message = null;
            switch (msgType) {
                case 1: {
                    message = (IMessage)gson.fromJson(reader, (Type)((Object)GenericMessage.class));
                    break;
                }
                case 10: {
                    message = (IMessage)gson.fromJson(reader, (Type)((Object)SuiteMessage.class));
                    break;
                }
                case 100: {
                    message = (IMessage)gson.fromJson(reader, (Type)((Object)TestMessage.class));
                    break;
                }
                case 1000: {
                    message = (IMessage)gson.fromJson(reader, (Type)((Object)TestResultMessage.class));
                    break;
                }
                default: {
                    throw new IOException("unknown message type: " + msgType + ", raw json: " + jsonMsg);
                }
            }
            reader.endObject();
            IMessage iMessage = message;
            return iMessage;
        }
    }

    private static void p(String msg) {
        if (RemoteTestNG.isVerbose()) {
            System.out.println("[JsonMessageSender] " + msg);
        }
    }
}

