/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import net.grinder.common.Test;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticExpression;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsView;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.FixedWidthFormatter;

public class StatisticsTable {
    private static final int COLUMN_WIDTH = 12;
    private static final String COLUMN_SEPARATOR = " ";
    private final TestStatisticsMap m_testStatisticsMap;
    private final DecimalFormat m_twoDPFormat = new DecimalFormat("0.00");
    private final String m_lineSeparator = System.getProperty("line.separator");
    private final FixedWidthFormatter m_headingFormatter = new FixedWidthFormatter(0, 10, 12);
    private final FixedWidthFormatter m_rowLabelFormatter = new FixedWidthFormatter(0, 8, 12);
    private final FixedWidthFormatter m_rowCellFormatter = new FixedWidthFormatter(0, 8, 12);
    private final FixedWidthFormatter m_freeTextFormatter = new FixedWidthFormatter(0, 10, 72);
    private final StatisticsView m_statisticsView;

    public StatisticsTable(StatisticsView statisticsView, TestStatisticsMap testStatisticsMap) {
        this.m_statisticsView = statisticsView;
        this.m_testStatisticsMap = testStatisticsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(final PrintWriter out) {
        boolean wrapped;
        ExpressionView[] expressionViews = this.m_statisticsView.getExpressionViews();
        int numberOfHeaderColumns = expressionViews.length + 1;
        StringBuffer[] cells = new StringBuffer[numberOfHeaderColumns];
        StringBuffer[] remainders = new StringBuffer[numberOfHeaderColumns];
        for (int i = 0; i < numberOfHeaderColumns; ++i) {
            cells[i] = new StringBuffer(i == 0 ? "" : expressionViews[i - 1].getDisplayName());
            remainders[i] = new StringBuffer();
        }
        do {
            wrapped = false;
            for (int i = 0; i < numberOfHeaderColumns; ++i) {
                remainders[i].setLength(0);
                this.m_headingFormatter.transform(cells[i], remainders[i]);
                out.print(cells[i].toString());
                out.print(COLUMN_SEPARATOR);
                if (remainders[i].length() <= 0) continue;
                wrapped = true;
            }
            out.println();
            StringBuffer[] otherArray = cells;
            cells = remainders;
            remainders = otherArray;
        } while (wrapped);
        out.println();
        final LineFormatter formatter = new LineFormatter(expressionViews);
        CompositeStatisticsLineFormater compositeTotalsFormatter = new CompositeStatisticsLineFormater(expressionViews);
        TestStatisticsMap testStatisticsMap = this.m_testStatisticsMap;
        synchronized (testStatisticsMap) {
            TestStatisticsMap testStatisticsMap2 = this.m_testStatisticsMap;
            testStatisticsMap2.getClass();
            new TestStatisticsMap.ForEach(testStatisticsMap2){

                public void next(Test test, StatisticsSet statistics) {
                    out.print(formatter.format("Test " + test.getNumber(), statistics));
                    String testDescription = test.getDescription();
                    if (testDescription != null) {
                        out.println(" \"" + testDescription + "\"");
                    } else {
                        out.println();
                    }
                }
            }.iterate();
            out.println();
            out.println(formatter.format("Totals", this.m_testStatisticsMap.nonCompositeStatisticsTotals()));
            StatisticsSet compositeStatisticsTotals = this.m_testStatisticsMap.compositeStatisticsTotals();
            if (!compositeStatisticsTotals.isZero()) {
                out.println(compositeTotalsFormatter.format("", compositeStatisticsTotals));
            }
        }
        out.println();
        StringBuffer text = new StringBuffer();
        StringBuffer buffer = new StringBuffer("Tests resulting in error only contribute to the Errors column. Statistics for individual tests can be found in the data file, including (possibly incomplete) statistics for erroneous tests. Composite tests are marked with () and not included in the totals.");
        while (buffer.length() > 0) {
            StringBuffer remainder = new StringBuffer();
            this.m_freeTextFormatter.transform(buffer, remainder);
            if (text.length() > 0) {
                text.append(this.m_lineSeparator);
            }
            text.append("  ");
            text.append(buffer.toString());
            buffer = remainder;
        }
        out.println(text);
    }

    private class CompositeStatisticsLineFormater
    extends LineFormatter {
        public CompositeStatisticsLineFormater(ExpressionView[] expressionViews) {
            super(expressionViews);
        }

        protected String formatExpression(ExpressionView expressionView, StatisticsSet statistics) {
            if (expressionView.getShowForCompositeStatistics()) {
                StringBuffer result = new StringBuffer("(");
                result.append(super.formatExpression(expressionView, statistics));
                result.append(")");
                return result.toString();
            }
            return "";
        }

        protected String startOfLine(StatisticsSet statistics) {
            return "";
        }

        protected String endOfLine(StatisticsSet statistics) {
            return "";
        }
    }

    private class LineFormatter {
        private final ExpressionView[] m_expressionViews;

        public LineFormatter(ExpressionView[] expressionViews) {
            this.m_expressionViews = expressionViews;
        }

        public String format(String rowLabel, StatisticsSet statistics) {
            StringBuffer result = new StringBuffer();
            StringBuffer cell = new StringBuffer();
            cell.append(this.startOfLine(statistics));
            cell.append(rowLabel);
            StringBuffer remainder = new StringBuffer();
            StatisticsTable.this.m_rowLabelFormatter.transform(cell, remainder);
            result.append(cell.toString());
            result.append(StatisticsTable.COLUMN_SEPARATOR);
            for (int i = 0; i < this.m_expressionViews.length; ++i) {
                StringBuffer statisticsCell = new StringBuffer(this.formatExpression(this.m_expressionViews[i], statistics));
                if (i == this.m_expressionViews.length - 1) {
                    statisticsCell.append(this.endOfLine(statistics));
                }
                StatisticsTable.this.m_rowCellFormatter.transform(statisticsCell, remainder);
                result.append(statisticsCell.toString());
                result.append(StatisticsTable.COLUMN_SEPARATOR);
            }
            return result.toString();
        }

        protected String startOfLine(StatisticsSet statistics) {
            if (statistics.isComposite()) {
                return "(";
            }
            return "";
        }

        protected String endOfLine(StatisticsSet statistics) {
            if (statistics.isComposite()) {
                return ")";
            }
            return "";
        }

        protected String formatExpression(ExpressionView expressionView, StatisticsSet statistics) {
            StatisticExpression expression = expressionView.getExpression();
            if (expression.isDouble()) {
                return StatisticsTable.this.m_twoDPFormat.format(expression.getDoubleValue(statistics));
            }
            return String.valueOf(expression.getLongValue(statistics));
        }
    }
}

