/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.messages.console;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.grinder.communication.Message;
import net.grinder.statistics.ExpressionView;
import net.grinder.statistics.StatisticsException;
import net.grinder.statistics.StatisticsServicesImplementation;

public final class RegisterExpressionViewMessage
implements Message,
Externalizable {
    private static final long serialVersionUID = 1L;
    private ExpressionView m_expressionView;

    public RegisterExpressionViewMessage(ExpressionView statisticsView) {
        this.m_expressionView = statisticsView;
    }

    public RegisterExpressionViewMessage() {
    }

    public ExpressionView getExpressionView() {
        return this.m_expressionView;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.m_expressionView.getExpressionString() == null) {
            throw new IOException("This expression view is not externalisable");
        }
        out.writeUTF(this.m_expressionView.getDisplayName());
        out.writeUTF(this.m_expressionView.getExpressionString());
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.m_expressionView = StatisticsServicesImplementation.getInstance().getStatisticExpressionFactory().createExpressionView(in.readUTF(), in.readUTF(), false);
        }
        catch (StatisticsException e) {
            throw new IOException("Could not instantiate ExpressionView: " + e.getMessage());
        }
    }
}

