/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.util.HashMap;
import java.util.Map;
import net.grinder.common.FilenameFactory;
import net.grinder.common.GrinderException;
import net.grinder.common.GrinderProperties;
import net.grinder.common.Logger;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.communication.QueuedSender;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ExternalFilenameFactory;
import net.grinder.engine.process.ExternalLogger;
import net.grinder.engine.process.PluginRegistryImplementation;
import net.grinder.engine.process.ProcessContext;
import net.grinder.engine.process.ProcessLifeCycleListener;
import net.grinder.engine.process.SSLControlImplementation;
import net.grinder.engine.process.ScriptContextImplementation;
import net.grinder.engine.process.ScriptStatisticsImplementation;
import net.grinder.engine.process.TestRegistryImplementation;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.engine.process.TestStatisticsHelperImplementation;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.ThreadStarter;
import net.grinder.engine.process.ThreadStopper;
import net.grinder.messages.console.ReportStatisticsMessage;
import net.grinder.messages.console.WorkerProcessReportMessage;
import net.grinder.script.Grinder;
import net.grinder.script.InternalScriptContext;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.TestStatisticsMap;
import net.grinder.util.JVM;
import net.grinder.util.ListenerSupport;
import net.grinder.util.Sleeper;
import net.grinder.util.SleeperImplementation;
import net.grinder.util.StandardTimeAuthority;
import net.grinder.util.TimeAuthority;

final class ProcessContextImplementation
implements ProcessContext {
    private final ListenerSupport m_processLifeCycleListeners = new ListenerSupport();
    private final ThreadContexts m_threadContexts = new ThreadContexts();
    private final WorkerIdentity m_workerIdentity;
    private final GrinderProperties m_properties;
    private final Logger m_processLogger;
    private final ThreadContextLocator m_threadContextLocator;
    private final TestRegistryImplementation m_testRegistryImplementation;
    private final InternalScriptContext m_scriptContext;
    private final Sleeper m_sleeper;
    private final StatisticsServices m_statisticsServices;
    private final TestStatisticsHelper m_testStatisticsHelper;
    private final TimeAuthority m_timeAuthority;
    private final boolean m_reportTimesToConsole;
    private volatile long m_executionStartTime;

    ProcessContextImplementation(WorkerIdentity workerIdentity, WorkerIdentity firstWorkerIdentity, GrinderProperties properties, Logger logger, FilenameFactory filenameFactory, QueuedSender consoleSender, StatisticsServices statisticsServices, ThreadStarter threadStarter) throws GrinderException {
        this.m_workerIdentity = workerIdentity;
        this.m_properties = properties;
        this.m_processLogger = logger;
        this.m_statisticsServices = statisticsServices;
        this.m_threadContextLocator = new ThreadContextLocatorImplementation();
        this.m_testStatisticsHelper = new TestStatisticsHelperImplementation(this.m_statisticsServices.getStatisticsIndexMap());
        TimeAuthority alternateTimeAuthority = null;
        if (properties.getBoolean("grinder.useNanoTime", false)) {
            if (!JVM.getInstance().isAtLeastVersion(1, 5)) {
                logger.output("grinder.useNanoTime=true requires J2SE 5 or later, ignoring this setting", 3);
            } else {
                try {
                    Class<?> nanoTimeClass = Class.forName("net.grinder.util.NanoTimeTimeAuthority");
                    alternateTimeAuthority = (TimeAuthority)nanoTimeClass.newInstance();
                    logger.output("Using System.nanoTime()");
                }
                catch (Exception e) {
                    throw new EngineException("Failed to load nanoTime() support", e);
                }
            }
        }
        this.m_timeAuthority = alternateTimeAuthority != null ? alternateTimeAuthority : new StandardTimeAuthority();
        ExternalLogger externalLogger = new ExternalLogger(this.m_processLogger, this.m_threadContextLocator);
        ExternalFilenameFactory externalFilenameFactory = new ExternalFilenameFactory(filenameFactory, this.m_threadContextLocator);
        this.m_sleeper = new SleeperImplementation(this.m_timeAuthority, externalLogger, properties.getDouble("grinder.sleepTimeFactor", 1.0), properties.getDouble("grinder.sleepTimeVariation", 0.2));
        SSLControlImplementation sslControl = new SSLControlImplementation(this.m_threadContextLocator);
        ScriptStatisticsImplementation scriptStatistics = new ScriptStatisticsImplementation(this.m_threadContextLocator, statisticsServices, consoleSender);
        this.m_testRegistryImplementation = new TestRegistryImplementation(this.m_threadContextLocator, statisticsServices.getStatisticsSetFactory(), this.m_testStatisticsHelper, this.m_timeAuthority);
        ThreadStopper threadStopper = new ThreadStopper(){

            public boolean stopThread(int threadNumber) {
                return ProcessContextImplementation.this.m_threadContexts.shutdown(threadNumber);
            }
        };
        this.m_scriptContext = new ScriptContextImplementation(this.m_workerIdentity, firstWorkerIdentity, this.m_threadContextLocator, properties, externalLogger, externalFilenameFactory, this.m_sleeper, sslControl, scriptStatistics, this.m_testRegistryImplementation, threadStarter, threadStopper);
        PluginRegistryImplementation pluginRegistry = new PluginRegistryImplementation(externalLogger, this.m_scriptContext, this.m_threadContextLocator, statisticsServices, this.m_timeAuthority);
        this.m_processLifeCycleListeners.add(pluginRegistry);
        this.m_processLifeCycleListeners.add(this.m_threadContexts);
        this.m_reportTimesToConsole = properties.getBoolean("grinder.reportTimesToConsole", true);
        Grinder.grinder = this.m_scriptContext;
    }

    public WorkerProcessReportMessage createStatusMessage(short state, short numberOfThreads, short totalNumberOfThreads) {
        return new WorkerProcessReportMessage(this.m_workerIdentity, state, numberOfThreads, totalNumberOfThreads);
    }

    public ReportStatisticsMessage createReportStatisticsMessage(TestStatisticsMap sample) {
        if (!this.m_reportTimesToConsole) {
            this.m_testStatisticsHelper.removeTestTimeFromSample(sample);
        }
        return new ReportStatisticsMessage(sample);
    }

    public Logger getProcessLogger() {
        return this.m_processLogger;
    }

    public TestRegistryImplementation getTestRegistry() {
        return this.m_testRegistryImplementation;
    }

    public GrinderProperties getProperties() {
        return this.m_properties;
    }

    public ThreadContextLocator getThreadContextLocator() {
        return this.m_threadContextLocator;
    }

    public void setExecutionStartTime() {
        this.m_executionStartTime = this.m_timeAuthority.getTimeInMilliseconds();
    }

    public long getExecutionStartTime() {
        return this.m_executionStartTime;
    }

    public long getElapsedTime() {
        return this.m_timeAuthority.getTimeInMilliseconds() - this.getExecutionStartTime();
    }

    public void shutdown() {
        SleeperImplementation.shutdownAllCurrentSleepers();
        this.m_threadContexts.shutdownAll();
    }

    public Sleeper getSleeper() {
        return this.m_sleeper;
    }

    public StatisticsServices getStatisticsServices() {
        return this.m_statisticsServices;
    }

    public void fireThreadCreatedEvent(final ThreadContext threadContext) {
        this.m_processLifeCycleListeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((ProcessLifeCycleListener)listener).threadCreated(threadContext);
            }
        });
    }

    private static final class ThreadContexts
    implements ProcessLifeCycleListener {
        private final Map m_threadContexts = new HashMap();
        private boolean m_allShutdown;

        private ThreadContexts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadCreated(ThreadContext threadContext) {
            boolean shutdown;
            Integer threadNumber = new Integer(threadContext.getThreadNumber());
            Map map = this.m_threadContexts;
            synchronized (map) {
                shutdown = this.m_allShutdown;
                if (!shutdown) {
                    threadContext.registerThreadLifeCycleListener(new SkeletonThreadLifeCycleListener(this, threadNumber){
                        private final /* synthetic */ Integer val$threadNumber;
                        private final /* synthetic */ ThreadContexts this$0;
                        {
                            this.this$0 = this$0;
                            this.val$threadNumber = val$threadNumber;
                        }

                        public void endThread() {
                            ThreadContexts.access$300(this.this$0).remove(this.val$threadNumber);
                        }
                    });
                    this.m_threadContexts.put(threadNumber, threadContext);
                }
            }
            if (shutdown) {
                threadContext.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shutdown(int threadNumber) {
            ThreadContext threadContext;
            Map map = this.m_threadContexts;
            synchronized (map) {
                threadContext = (ThreadContext)this.m_threadContexts.get(new Integer(threadNumber));
            }
            if (threadContext != null) {
                threadContext.shutdown();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAll() {
            ThreadContext[] threadContexts;
            Map map = this.m_threadContexts;
            synchronized (map) {
                this.m_allShutdown = true;
                threadContexts = this.m_threadContexts.values().toArray(new ThreadContext[this.m_threadContexts.size()]);
            }
            for (int i = 0; i < threadContexts.length; ++i) {
                threadContexts[i].shutdown();
            }
        }

        static /* synthetic */ Map access$300(ThreadContexts x0) {
            return x0.m_threadContexts;
        }
    }

    private static final class ThreadContextLocatorImplementation
    implements ThreadContextLocator {
        private final ThreadLocal m_threadContextThreadLocal = new ThreadLocal();

        private ThreadContextLocatorImplementation() {
        }

        public ThreadContext get() {
            return (ThreadContext)this.m_threadContextThreadLocal.get();
        }

        public void set(ThreadContext threadContext) {
            this.m_threadContextThreadLocal.set(threadContext);
        }
    }
}

