/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.PrintWriter;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.ThreadLogger;
import net.grinder.plugininterface.GrinderPlugin;
import net.grinder.plugininterface.PluginException;
import net.grinder.plugininterface.PluginProcessContext;
import net.grinder.plugininterface.PluginThreadListener;
import net.grinder.script.Grinder;
import net.grinder.statistics.StatisticsServices;
import net.grinder.util.TimeAuthority;

final class RegisteredPlugin
implements PluginProcessContext {
    private final GrinderPlugin m_plugin;
    private final Grinder.ScriptContext m_scriptContext;
    private final ThreadContextLocator m_threadContextLocator;
    private final StatisticsServices m_statisticsServices;
    private final ThreadLocal m_threadListenerThreadLocal = new ThreadLocal();
    private final TimeAuthority m_timeAuthority;

    public RegisteredPlugin(GrinderPlugin plugin, Grinder.ScriptContext scriptContext, ThreadContextLocator threadContextLocator, StatisticsServices statisticsServices, TimeAuthority timeAuthority) {
        this.m_plugin = plugin;
        this.m_scriptContext = scriptContext;
        this.m_threadContextLocator = threadContextLocator;
        this.m_statisticsServices = statisticsServices;
        this.m_timeAuthority = timeAuthority;
    }

    public Grinder.ScriptContext getScriptContext() {
        return this.m_scriptContext;
    }

    public PluginThreadListener getPluginThreadListener() throws EngineException {
        ThreadContext threadContext = this.m_threadContextLocator.get();
        if (threadContext == null) {
            throw new EngineException("Must be called from worker thread");
        }
        return this.createPluginThreadListener(threadContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginThreadListener createPluginThreadListener(ThreadContext threadContext) throws EngineException {
        PluginThreadListener newPluginThreadListener;
        PluginThreadListener existingPluginThreadListener = (PluginThreadListener)this.m_threadListenerThreadLocal.get();
        if (existingPluginThreadListener != null) {
            return existingPluginThreadListener;
        }
        try {
            newPluginThreadListener = this.m_plugin.createThreadListener(threadContext);
        }
        catch (PluginException e) {
            PrintWriter errorLogWriter;
            ThreadLogger logger = threadContext.getThreadLogger();
            PrintWriter printWriter = errorLogWriter = logger.getErrorLogWriter();
            synchronized (printWriter) {
                logger.error("Plugin could not create thread listener: " + e);
                e.printStackTrace(errorLogWriter);
            }
            throw new EngineException("Plugin could not create thread listener", e);
        }
        this.m_threadListenerThreadLocal.set(newPluginThreadListener);
        threadContext.registerThreadLifeCycleListener(newPluginThreadListener);
        return newPluginThreadListener;
    }

    public StatisticsServices getStatisticsServices() {
        return this.m_statisticsServices;
    }

    public TimeAuthority getTimeAuthority() {
        return this.m_timeAuthority;
    }
}

