/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.editor;

import net.grinder.console.editor.TextSource;
import net.grinder.util.ListenerSupport;

public abstract class AbstractTextSource
implements TextSource {
    private boolean m_dirty = true;
    private final ListenerSupport m_listeners = new ListenerSupport();

    public boolean isDirty() {
        return this.m_dirty;
    }

    protected final void setClean() {
        boolean oldDirty = this.m_dirty;
        this.m_dirty = false;
        this.fireTextSourceChanged(oldDirty);
    }

    protected final void setChanged() {
        boolean oldDirty = this.m_dirty;
        this.m_dirty = true;
        this.fireTextSourceChanged(!oldDirty);
    }

    public void addListener(TextSource.Listener listener) {
        this.m_listeners.add(listener);
    }

    private void fireTextSourceChanged(final boolean firstEdit) {
        this.m_listeners.apply(new ListenerSupport.Informer(){

            public void inform(Object listener) {
                ((TextSource.Listener)listener).textSourceChanged(firstEdit);
            }
        });
    }
}

