/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.collect.Ordering;

final class ByFunctionOrdering<F, T>
extends Ordering<F>
implements Serializable {
    private Function<F, ? extends T> function;
    private Ordering<T> ordering;

    ByFunctionOrdering(Function<F, ? extends T> function, Ordering<T> ordering) {
        this.function = CharMatcher.LookupTable.checkNotNull(function);
        this.ordering = CharMatcher.LookupTable.checkNotNull(ordering);
    }

    @Override
    public final int compare(F left, F right) {
        return this.ordering.compare(this.function.apply(left), this.function.apply(right));
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ByFunctionOrdering) {
            ByFunctionOrdering that = (ByFunctionOrdering)object;
            return this.function.equals(that.function) && this.ordering.equals(that.ordering);
        }
        return false;
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.function, this.ordering};
        return Arrays.hashCode(objectArray);
    }

    public final String toString() {
        return this.ordering + ".onResultOf(" + this.function + ")";
    }
}

