/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.python.core.BaseBytes;
import org.python.core.BaseBytesTest;
import org.python.core.Py;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class PyByteArrayTest
extends BaseBytesTest {
    public PyByteArrayTest(String name) {
        super(name);
    }

    public static int[] patternInts(int na, int nd, int nb, String c) {
        int i;
        int[] r = new int[na + nd + nb];
        int p = 0;
        for (i = 0; i < na; ++i) {
            r[p++] = c.charAt(0);
        }
        for (i = 0; i < nd; ++i) {
            r[p++] = c.charAt(1);
        }
        for (i = 0; i < nb; ++i) {
            r[p++] = c.charAt(2);
        }
        return r;
    }

    public static int[] adbInts(int na, int nd, int nb) {
        return PyByteArrayTest.patternInts(na, nd, nb, "aDb");
    }

    public static int[] aebInts(int na, int ne, int nb) {
        return PyByteArrayTest.patternInts(na, ne, nb, "aEb");
    }

    public static int[][] randomSliceProblem(Random random, int na, int nd, int nb, int ne) {
        int i;
        int[] adb = new int[na + nd + nb];
        int[] aeb = new int[na + ne + nb];
        int[] e = new int[ne];
        int[][] ret = new int[][]{adb, aeb, e};
        int p = 0;
        int q = 0;
        for (i = 0; i < na; ++i) {
            int a = random.nextInt(256);
            adb[p++] = a;
            aeb[q++] = a;
        }
        for (i = 0; i < nd; ++i) {
            int d = random.nextInt(256);
            adb[p++] = d;
        }
        for (i = 0; i < ne; ++i) {
            int x = random.nextInt(256);
            e[p++] = x;
            aeb[q++] = x;
        }
        for (i = 0; i < nb; ++i) {
            int b = random.nextInt(256);
            adb[p++] = b;
            aeb[q++] = b;
        }
        return ret;
    }

    public static void checkSlice(int na, int nd, int nb, int ne, int[] x, int[] y, BaseBytes result) {
        PyByteArrayTest.assertEquals((String)"size", (int)(na + ne + nb), (int)result.size());
        PyByteArrayTest.checkInts(x, 0, result, 0, na);
        PyByteArrayTest.checkInts(y, 0, result, na, ne);
        PyByteArrayTest.checkInts(x, na + nd, result, na + ne, nb);
    }

    public static void checkSlice(int start, int step, int n, int[] x, int[] y, BaseBytes u) {
        int px;
        PyByteArrayTest.assertEquals((String)"size", (int)x.length, (int)u.size());
        if (step > 0) {
            int px2;
            int py = 0;
            for (px2 = 0; px2 < start; ++px2) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px2], (int)u.intAt(px2));
            }
            if (n > 0) {
                ++py;
                PyByteArrayTest.assertEquals((String)"first affected", (int)y[0], (int)u.intAt(px2++));
            }
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px2], (int)u.intAt(px2));
                    ++j;
                    ++px2;
                }
                PyByteArrayTest.assertEquals((String)"next affected", (int)y[py++], (int)u.intAt(px2++));
            }
            while (px2 < x.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px2], (int)u.intAt(px2));
                ++px2;
            }
            return;
        }
        step = -step;
        int py = 0;
        for (px = x.length - 1; px > start; --px) {
            PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(px));
        }
        if (n > 0) {
            ++py;
            PyByteArrayTest.assertEquals((String)"first affected", (int)y[0], (int)u.intAt(px--));
        }
        for (int i = 1; i < n; ++i) {
            int j = 1;
            while (j < step) {
                PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(px));
                ++j;
                --px;
            }
            PyByteArrayTest.assertEquals((String)"next affected", (int)y[py++], (int)u.intAt(px--));
        }
        while (px >= 0) {
            PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(px));
            --px;
        }
    }

    public static void checkDelSlice(int start, int step, int n, int[] x, BaseBytes u) {
        int px;
        PyByteArrayTest.assertEquals((String)"size", (int)(x.length - n), (int)u.size());
        if (step > 0) {
            int px2;
            int pu = 0;
            for (px2 = 0; px2 < start; ++px2) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x[px2], (int)u.intAt(pu++));
            }
            ++px2;
            for (int i = 1; i < n; ++i) {
                int j = 1;
                while (j < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x[px2], (int)u.intAt(pu++));
                    ++j;
                    ++px2;
                }
                ++px2;
            }
            while (px2 < x.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x[px2], (int)u.intAt(pu++));
                ++px2;
            }
            return;
        }
        step = -step;
        int pu = u.size - 1;
        for (px = x.length - 1; px > start; --px) {
            PyByteArrayTest.assertEquals((String)"after slice", (int)x[px], (int)u.intAt(pu--));
        }
        --px;
        for (int i = 1; i < n; ++i) {
            int j = 1;
            while (j < step) {
                PyByteArrayTest.assertEquals((String)"in gap", (int)x[px], (int)u.intAt(pu--));
                ++j;
                --px;
            }
            --px;
        }
        while (px >= 0) {
            PyByteArrayTest.assertEquals((String)"before slice", (int)x[px], (int)u.intAt(pu--));
            --px;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test__getslice__2() {
        String ver = "D\ufffdrob\ufffde au sang de nos c\ufffdurs";
        int L = "D\ufffdrob\ufffde au sang de nos c\ufffdurs".length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L);
        new PythonInterpreter();
        int[] posStart = new int[]{0, 8, 16, L - 5, L - 1};
        int[] arr$ = posStart;
        for (int i$ = 0; i$ < 5; ++i$) {
            int start = arr$[i$];
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            for (int stop = start; stop <= L; ++stop) {
                bList.clear();
                for (int i = start; i < stop; ++i) {
                    bList.add(new PyInteger(aRef[i]));
                }
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                this.doTest__getslice__2(a, pyStart, pyStop, bList, 2);
                this.doTest__getslice__2(a, pyStart_L, pyStop, bList, 0);
                this.doTest__getslice__2(a, pyStart, pyStop_L, bList, 0);
                this.doTest__getslice__2(a, pyStart_L, pyStop_L, bList, 0);
            }
        }
    }

    private void doTest__getslice__2(BaseBytes a, PyObject pyStart, PyObject pyStop, List<PyInteger> bList, int verbose) {
        if (verbose >= 4) {
            System.out.printf("    __getslice__(%s,%s)\n", pyStart, pyStop);
        }
        PyObject b = a.__getslice__(pyStart, pyStop);
        if (verbose >= 3) {
            System.out.println(this.toString((BaseBytes)b));
        }
        PyByteArrayTest.checkInts(bList, b);
    }

    public void test__getslice__3() {
        String ver = "Quand je br\u00fble et que tu t'enflammes ;";
        int L = "Quand je br\u00fble et que tu t'enflammes ;".length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L);
        new PythonInterpreter();
        int[] posStart = new int[]{0, 9, 22, L - 11, L - 1};
        for (int step = 1; step < 4; ++step) {
            PyInteger pyStep = new PyInteger(step);
            int[] arr$ = posStart;
            for (int i$ = 0; i$ < 5; ++i$) {
                int start = arr$[i$];
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
                for (int stop = start; stop <= L; ++stop) {
                    bList.clear();
                    for (int i = start; i < stop; i += step) {
                        bList.add(new PyInteger(aRef[i]));
                    }
                    PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                    PyInteger pyStop = new PyInteger(stop);
                    this.doTest__getslice__3(a, pyStart, pyStop, pyStep, bList, 2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop, pyStep, bList, 0);
                    this.doTest__getslice__3(a, pyStart, pyStop_L, pyStep, bList, 0);
                    this.doTest__getslice__3(a, pyStart_L, pyStop_L, pyStep, bList, 0);
                }
            }
        }
        int[] negStart = new int[]{0, 5, 14, L - 10, L - 1};
        for (int step = -1; step > -4; --step) {
            PyInteger pyStep = new PyInteger(step);
            int[] arr$ = negStart;
            for (int i$ = 0; i$ < 5; ++i$) {
                int start = arr$[i$];
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start < L - 1 ? new PyInteger(start - L) : Py.None;
                for (int stop = start; stop >= -1; --stop) {
                    PyObject pyStop_L;
                    bList.clear();
                    for (int i = start; i > stop; i += step) {
                        bList.add(new PyInteger(aRef[i]));
                    }
                    if (stop >= 0) {
                        pyStop_L = new PyInteger(stop - L);
                    } else {
                        stop = -(L + 1);
                        pyStop_L = Py.None;
                    }
                    PyInteger pyStop = new PyInteger(stop);
                    this.doTest__getslice__3(a, pyStart, pyStop, pyStep, bList, 2);
                    this.doTest__getslice__3(a, pyStart_L, pyStop, pyStep, bList, 0);
                    this.doTest__getslice__3(a, pyStart, pyStop_L, pyStep, bList, 0);
                    this.doTest__getslice__3(a, pyStart_L, pyStop_L, pyStep, bList, 0);
                }
            }
        }
    }

    private void doTest__getslice__3(BaseBytes a, PyObject pyStart, PyObject pyStop, PyObject pyStep, List<PyInteger> bList, int verbose) {
        if (verbose >= 4) {
            System.out.printf("    __getslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
        }
        PyObject b = a.__getslice__(pyStart, pyStop, pyStep);
        if (verbose >= 3) {
            System.out.println(this.toString((BaseBytes)b));
        }
        PyByteArrayTest.checkInts(bList, b);
    }

    @Override
    public void testPyset() {
        new PythonInterpreter();
        int[] aRef = PyByteArrayTest.randomInts(this.random, 25);
        PyByteArray a = this.getInstance(aRef);
        for (int i = 0; i < 25; ++i) {
            int b = aRef[i] ^ 0x55;
            PyInteger pyb = new PyInteger(b);
            a.__setitem__(i, (PyObject)pyb);
            int ai = a.pyget(i).asInt();
            PyByteArrayTest.assertEquals((int)b, (int)ai);
        }
        int[] badValue = new int[]{256, Integer.MAX_VALUE, -1, -2, -100, -65536, Integer.MIN_VALUE};
        int[] arr$ = badValue;
        for (int i$ = 0; i$ < 7; ++i$) {
            int i = arr$[i$];
            PyInteger b = new PyInteger(i);
            try {
                a.__setitem__(0, (PyObject)b);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(0, " + b + ")"));
                continue;
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.ValueError, (Object)pye.type);
            }
        }
        PyInteger x = new PyInteger(10);
        int[] arr$2 = new int[]{-26, -125, 25, 26};
        for (int i$ = 0; i$ < 4; ++i$) {
            int i = arr$2[i$];
            try {
                a.__setitem__(i, (PyObject)x);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(" + i + ", x)"));
                continue;
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.IndexError, (Object)pye.type);
            }
        }
    }

    public void testSetslice2() {
        int i$;
        int[] arr$;
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        int[] neList = new int[]{4, 5, 6, 20, 0};
        int[] arr$2 = neList;
        for (int i$2 = 0; i$2 < 5; ++i$2) {
            int ne = arr$2[i$2];
            int[] eInts = new int[ne];
            Arrays.fill(eInts, 69);
            PyByteArray e = new PyByteArray(eInts);
            int[] arr$3 = ndList;
            for (int i$3 = 0; i$3 < 3; ++i$3) {
                int nd = arr$3[i$3];
                arr$ = naList;
                for (i$ = 0; i$ < 3; ++i$) {
                    int na = arr$[i$];
                    int[] arr$4 = nbList;
                    for (int i$4 = 0; i$4 < 3; ++i$4) {
                        int nb = arr$4[i$4];
                        int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                        int[] bRef = PyByteArrayTest.aebInts(na, ne, nb);
                        PyByteArray b = this.getInstance(aRef);
                        byte[] cfr_ignored_0 = b.storage;
                        b.setslice(na, na + nd, 1, (PyObject)e);
                        PyByteArrayTest.checkInts(bRef, (BaseBytes)b);
                    }
                }
            }
        }
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        int[] yInts = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        PyByteArray x = this.getInstance(xInts);
        PyByteArray y = this.getInstance(yInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            arr$ = nbList2;
            for (i$ = 0; i$ < 3; ++i$) {
                int nb = arr$[i$];
                for (int nd = 0; nd < 25; ++nd) {
                    for (int ne = 0; ne < 25; ++ne) {
                        PyByteArray u = x.getslice(0, na + nd + nb, 1);
                        PyByteArray e = y.getslice(0, ne, 1);
                        u.setslice(na, na + nd, 1, (PyObject)e);
                        PyByteArrayTest.checkSlice(na, nd, nb, ne, xInts, yInts, u);
                    }
                }
            }
        }
    }

    public void test__setslice__2() {
        String ver = "Cet autre affecte tes langueurs";
        int L = "Cet autre affecte tes langueurs".length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 14, 86, 90);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] posStart = new int[]{0, 4, 10, 18, L - 9};
        int[] posStop = new int[]{0, 3, 9, 17, L - 10, L};
        int[] arr$ = posStart;
        for (int i$ = 0; i$ < 5; ++i$) {
            int start = arr$[i$];
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            int[] arr$2 = posStop;
            for (int i$2 = 0; i$2 < 6; ++i$2) {
                int stop = arr$2[i$2];
                if (stop < start) continue;
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                for (int n = 0; n <= eRef.length; ++n) {
                    this.doTest__setslice__2(uRef, pyStart, pyStop, eFull, n, eRef, start, stop, 2);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop, eFull, n, eRef, start, stop, 0);
                    this.doTest__setslice__2(uRef, pyStart, pyStop_L, eFull, n, eRef, start, stop, 0);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop_L, eFull, n, eRef, start, stop, 0);
                }
            }
        }
    }

    private void doTest__setslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, BaseBytes eFull, int n, int[] eRef, int start, int stop, int verbose) {
        PyByteArray u = this.getInstance(uRef);
        BaseBytes e = eFull.getslice(0, n, 1);
        if (verbose >= 4) {
            System.out.printf("    __setslice__(%s,%s,e[0:%d])\n", pyStart, pyStop, n);
            System.out.println("u = " + this.toString(u));
            System.out.println("e = " + this.toString(e));
        }
        u.__setslice__(pyStart, pyStop, e);
        if (verbose >= 3) {
            System.out.println("u'= " + this.toString(u));
        }
        int nd = stop - start;
        int nb = uRef.length - stop;
        PyByteArrayTest.checkSlice(start, nd, nb, n, uRef, eRef, u);
    }

    @Override
    public void testSetslice3() {
        new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            int len = uRef.length - start;
            int[] arr$ = posStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        u.setslice(start, stop, step, (PyObject)e);
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            int len = start + 1;
            int[] arr$ = negStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                int nmax = (len - step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        u.setslice(start, stop, step, (PyObject)e);
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
    }

    public void test__setslice__3() {
        new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            int[] arr$ = posStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        u.__setslice__(pyStart, pyStop, pyStep, e);
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            int[] arr$ = negStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len - step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        BaseBytes e = ((BaseBytes)eFull).getslice(0, n, 1);
                        u.__setslice__(pyStart, pyStop, pyStep, e);
                        PyByteArrayTest.checkSlice(start, step, n, uRef, eRef, u);
                    }
                }
            }
        }
    }

    public void testSetsliceTime() {
        this.timeSetslice(100, 200, 7, 14, 1);
        this.timeSetslice(100, 200, 25, 25, 1);
        this.timeSetslice(1000, 20, 10000, 2000, 1);
    }

    private void timeSetslice(int trials, int repeats, int N, int M, int verbose) {
        int[] startList = new int[11];
        for (int i = 0; i < 11; ++i) {
            startList[i] = N * i / 10;
        }
        int[] changeList = new int[11];
        for (int i = 0; i < 11; ++i) {
            changeList[i] = M * i / 10;
        }
        long[][] elapsed = new long[11][11];
        for (int row = 0; row < 11; ++row) {
            for (int col = 0; col < 11; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N, 117, 122);
        PyByteArray x = this.getInstance(xRef);
        int[] yRef = PyByteArrayTest.randomInts(this.random, M, 65, 72);
        PyByteArray y = this.getInstance(yRef);
        PyByteArray[] u = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < 11; ++irow) {
                int row = (irow + 5 * trial) % 11;
                int na = startList[row];
                for (int icol = 0; icol < 11; ++icol) {
                    long t;
                    int col = (icol + trial) % 11;
                    int ne = changeList[col];
                    int start = na;
                    int stop = na;
                    PyByteArray e = y.getslice(0, ne, 1);
                    if (trial == 0) {
                        this.doTimeSetslice(u, start, stop, e, x, verbose);
                        PyByteArrayTest.checkSlice(na, 0, N - na, ne, xRef, yRef, u[0]);
                    }
                    if ((t = this.doTimeSetslice(u, start, stop, e, x, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t;
                }
            }
        }
        if (verbose > 0) {
            System.out.print("     N  ,     na  ");
            for (int col = 0; col < 11; ++col) {
                System.out.printf(", ne=%7d", changeList[col]);
            }
            System.out.println(", elements inserted: time in microseconds.");
            for (int row = 0; row < 11; ++row) {
                System.out.printf("%8d, %8d", N, startList[row]);
                for (int col = 0; col < 11; ++col) {
                    double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                    System.out.printf(", %10.3f", usPerCall);
                }
                System.out.println();
            }
        }
    }

    private long doTimeSetslice(PyByteArray[] u, int start, int stop, BaseBytes e, BaseBytes x, int verbose) {
        int repeats = 1;
        if (verbose < 0) {
            repeats = u.length;
        }
        for (int i = 0; i < repeats; ++i) {
            u[i] = new PyByteArray(x);
        }
        PyByteArray v = u[0];
        byte[] oldStorage = v.storage;
        if (verbose >= 3) {
            System.out.printf("setslice(%d,%d,%d,e[%d])\n", start, stop, 1, e.size());
            System.out.println("u = " + this.toString(v));
            System.out.println("e = " + this.toString(e));
        }
        long beginTime = System.nanoTime();
        for (int i = 0; i < repeats; ++i) {
            u[i].setslice(start, stop, 1, (PyObject)e);
        }
        long t = System.nanoTime() - beginTime;
        if (verbose >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v.storage != oldStorage;
            if (v.size << 1 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v) + (avAlloc ? " new" : ""));
        }
        return t;
    }

    public void testDelslice2() {
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        int[] arr$ = ndList;
        for (int i$ = 0; i$ < 3; ++i$) {
            int nd = arr$[i$];
            int[] arr$2 = naList;
            for (int i$2 = 0; i$2 < 3; ++i$2) {
                int na = arr$2[i$2];
                int[] arr$3 = nbList;
                for (int i$3 = 0; i$3 < 3; ++i$3) {
                    int nb = arr$3[i$3];
                    int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                    int[] bRef = PyByteArrayTest.aebInts(na, 0, nb);
                    PyByteArray b = this.getInstance(aRef);
                    byte[] cfr_ignored_0 = b.storage;
                    b.delslice(na, na + nd, 1);
                    PyByteArrayTest.checkInts(bRef, (BaseBytes)b);
                }
            }
        }
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        PyByteArray x = this.getInstance(xInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            int[] arr$4 = nbList2;
            for (int i$ = 0; i$ < 3; ++i$) {
                int nb = arr$4[i$];
                for (int nd = 0; nd < 25; ++nd) {
                    PyByteArray u = x.getslice(0, na + nd + nb, 1);
                    u.delslice(na, na + nd, 1);
                    PyByteArrayTest.checkSlice(na, nd, nb, 0, xInts, null, u);
                }
            }
        }
    }

    public void test__delslice__2() {
        String ver = "Et tes p\u00e2leurs, alors que lasse,";
        int L = "Et tes p\u00e2leurs, alors que lasse,".length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        new PythonInterpreter();
        int[] posStart = new int[]{0, 3, 7, 16, L - 1};
        int[] posStop = new int[]{0, 3, 7, 16, L - 6, L};
        int[] arr$ = posStart;
        for (int i$ = 0; i$ < 5; ++i$) {
            int start = arr$[i$];
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L) : Py.None;
            int[] arr$2 = posStop;
            for (int i$2 = 0; i$2 < 6; ++i$2) {
                int stop = arr$2[i$2];
                if (stop < start) continue;
                PyObject pyStop_L = stop < L ? new PyInteger(stop - L) : Py.None;
                PyInteger pyStop = new PyInteger(stop);
                this.doTest__delslice__2(uRef, pyStart, pyStop, start, stop, 2);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop, start, stop, 0);
                this.doTest__delslice__2(uRef, pyStart, pyStop_L, start, stop, 0);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop_L, start, stop, 0);
            }
        }
    }

    private void doTest__delslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, int start, int stop, int verbose) {
        PyByteArray u = this.getInstance(uRef);
        if (verbose >= 4) {
            System.out.printf("    __delslice__(%s,%s,1)\n", pyStart, pyStop);
            System.out.println("u = " + this.toString(u));
        }
        u.__delslice__(pyStart, pyStop);
        if (verbose >= 3) {
            System.out.println("u'= " + this.toString(u));
        }
        int nd = stop - start;
        int nb = uRef.length - stop;
        PyByteArrayTest.checkSlice(start, nd, nb, 0, uRef, null, u);
    }

    public void test__delslice__3() {
        new PythonInterpreter();
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            int[] arr$ = posStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n = 1; n <= nmax; ++n) {
                    int last = start + step * (n - 1) + 1;
                    for (int stop = last + 1; stop < last + step; ++stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        u.__delslice__(pyStart, pyStop, pyStep);
                        PyByteArrayTest.checkDelSlice(start, step, n, uRef, u);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            int[] arr$ = negStep;
            for (int i$ = 0; i$ < 6; ++i$) {
                int step = arr$[i$];
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len - step - 1) / -step;
                for (int n = 1; n <= nmax; ++n) {
                    int last;
                    for (int stop = last = start + step * (n - 1) - 1; stop > last - -step && stop >= 0; --stop) {
                        PyInteger pyStop = new PyInteger(stop);
                        PyByteArray u = this.getInstance(uRef);
                        u.__delslice__(pyStart, pyStop, pyStep);
                        PyByteArrayTest.checkDelSlice(start, step, n, uRef, u);
                    }
                }
            }
        }
    }

    public void testDelsliceTime3() {
        this.timeDelslice3(100, 200, 7, 1);
        this.timeDelslice3(100, 200, 25, 1);
        this.timeDelslice3(10, 4, 10000, 1);
    }

    private void timeDelslice3(int trials, int repeats, int N, int verbose) {
        int[] startList = new int[10];
        for (int i = 0; i < 10; ++i) {
            startList[i] = N * i / 10;
        }
        int[] posStep = new int[]{1, 2, 3, 5, 10};
        int[] stepList = new int[10];
        for (int i = 0; i < 5; ++i) {
            stepList[5 - i - 1] = posStep[i];
            stepList[i + 5] = -posStep[i];
        }
        long[][] elapsed = new long[10][10];
        for (int row = 0; row < 10; ++row) {
            for (int col = 0; col < 10; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N, 117, 122);
        PyByteArray x = this.getInstance(xRef);
        PyByteArray[] u = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < 10; ++irow) {
                int row = (irow + 5 * trial) % 10;
                int start = startList[row];
                for (int icol = 0; icol < 10; ++icol) {
                    long t;
                    int col = (icol + trial) % 10;
                    int step = stepList[col];
                    int n = step > 0 ? (xRef.length - start + step - 1) / step : (start - step) / -step;
                    PyInteger pyStart = new PyInteger(start);
                    PyObject pyStop = Py.None;
                    PyInteger pyStep = new PyInteger(step);
                    if (trial == 0) {
                        this.doTimeDelslice3(u, pyStart, pyStop, pyStep, x, verbose);
                        PyByteArrayTest.checkDelSlice(start, step, n, xRef, u[0]);
                    }
                    if ((t = this.doTimeDelslice3(u, pyStart, pyStop, pyStep, x, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t;
                }
            }
        }
        System.out.print("     N  ,    start");
        for (int col = 0; col < 10; ++col) {
            System.out.printf(", step=%5d", stepList[col]);
        }
        System.out.println(", deletion time in microseconds.");
        for (int row = 0; row < 10; ++row) {
            System.out.printf("%8d, %8d", N, startList[row]);
            for (int col = 0; col < 10; ++col) {
                double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                System.out.printf(", %10.3f", usPerCall);
            }
            System.out.println();
        }
    }

    private long doTimeDelslice3(PyByteArray[] u, PyObject pyStart, PyObject pyStop, PyObject pyStep, BaseBytes x, int verbose) {
        int repeats = 1;
        if (verbose < 0) {
            repeats = u.length;
        }
        for (int i = 0; i < repeats; ++i) {
            u[i] = new PyByteArray(x);
        }
        PyByteArray v = u[0];
        byte[] oldStorage = v.storage;
        if (verbose >= 3) {
            System.out.printf("__delslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
            System.out.println("u = " + this.toString(v));
        }
        long beginTime = System.nanoTime();
        for (int i = 0; i < repeats; ++i) {
            u[i].__delslice__(pyStart, pyStop, pyStep);
        }
        long t = System.nanoTime() - beginTime;
        if (verbose >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v.storage != oldStorage;
            if (v.size << 1 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v) + (avAlloc ? " new" : ""));
        }
        return t;
    }

    @Override
    public PyByteArray getInstance(PyType type) {
        return new PyByteArray(type);
    }

    @Override
    public PyByteArray getInstance() {
        return new PyByteArray();
    }

    @Override
    public PyByteArray getInstance(int size) {
        return new PyByteArray(size);
    }

    @Override
    public PyByteArray getInstance(int[] value) {
        return new PyByteArray(value);
    }

    @Override
    public PyByteArray getInstance(BaseBytes source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(Iterable<? extends PyObject> source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(PyString arg, PyObject encoding, PyObject errors) {
        return new PyByteArray(arg, encoding, errors);
    }

    @Override
    public PyByteArray getInstance(PyString arg, String encoding, String errors) {
        return new PyByteArray(arg, encoding, errors);
    }

    @Override
    public PyByteArray getInstance(PyObject arg) throws PyException {
        return new PyByteArray(arg);
    }
}

