/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import net.grinder.common.Logger;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.FilenameFactoryImplementation;
import net.grinder.engine.process.ThreadLogger;
import net.grinder.util.DelayedCreationFileWriter;

final class LoggerImplementation {
    private static final char[] s_lineSeparator = System.getProperty("line.separator").toCharArray();
    private static final DateFormat s_dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private static final DecimalFormat s_fiveDigitFormat = new DecimalFormat("00000");
    private static String s_dateString;
    private static volatile int s_currentTick;
    private static volatile int s_lastTick;
    private final PrintWriter m_stdoutWriter = new PrintWriter(System.out);
    private final PrintWriter m_stderrWriter = new PrintWriter(System.err);
    private final String m_grinderID;
    private final boolean m_logProcessStreams;
    private final File m_logDirectory;
    private final FilenameFactoryImplementation m_filenameFactory;
    private final PrintWriter m_outputWriter;
    private final PrintWriter m_errorWriter;
    private final File m_errorFile;
    private final PrintWriter m_dataWriter;
    private final Logger m_processLogger;
    private boolean m_errorOccurred = false;

    static void tick() {
        ++s_currentTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDateString() {
        if (s_lastTick != s_currentTick) {
            DateFormat dateFormat = s_dateFormat;
            synchronized (dateFormat) {
                s_dateString = s_dateFormat.format(new Date());
            }
            s_lastTick = s_currentTick;
        }
        return s_dateString;
    }

    LoggerImplementation(String grinderID, String logDirectoryString, boolean logProcessStreams, int numberOfOldLogs) throws EngineException {
        this.m_grinderID = grinderID;
        this.m_logProcessStreams = logProcessStreams;
        this.m_logDirectory = new File(logDirectoryString, "");
        this.m_filenameFactory = new FilenameFactoryImplementation(this.m_logDirectory, grinderID);
        FileManager fileManager = new FileManager(numberOfOldLogs);
        this.m_errorFile = fileManager.getErrorFile();
        this.m_outputWriter = new PrintWriter(fileManager.getOutWriter(), true);
        this.m_errorWriter = new PrintWriter(fileManager.getErrorWriter(), true);
        this.m_dataWriter = new PrintWriter(fileManager.getDataWriter(), false);
        this.m_processLogger = this.createThreadLogger(-1);
    }

    public void close() {
        this.m_outputWriter.close();
        this.m_errorWriter.close();
        this.m_dataWriter.close();
    }

    Logger getProcessLogger() {
        return this.m_processLogger;
    }

    ThreadLogger createThreadLogger(int threadID) {
        return new ThreadState(threadID);
    }

    public FilenameFactoryImplementation getFilenameFactory() {
        return this.m_filenameFactory;
    }

    public PrintWriter getDataWriter() {
        return this.m_dataWriter;
    }

    private void outputInternal(ThreadState state, String message, int where) {
        int w = where;
        if (!this.m_logProcessStreams) {
            w &= 0xFFFFFFFE;
        }
        if (w != 0) {
            char[] formattedMessage = state.formatMessage(message);
            if ((w & 1) != 0) {
                this.m_outputWriter.write(formattedMessage);
                this.m_outputWriter.flush();
            }
            if ((w & 2) != 0) {
                this.m_stdoutWriter.write(formattedMessage);
                this.m_stdoutWriter.flush();
            }
        }
    }

    private void errorInternal(ThreadState state, String message, int where) {
        int w = where;
        if (w != 0) {
            if (!this.m_logProcessStreams) {
                w &= 0xFFFFFFFE;
            }
            char[] formattedMessage = state.formatMessage(message);
            if ((w & 1) != 0) {
                this.m_errorWriter.write(formattedMessage);
                this.m_errorWriter.flush();
            }
            if ((w & 2) != 0) {
                this.m_stderrWriter.write(formattedMessage);
                this.m_stderrWriter.flush();
            } else if (!this.m_errorOccurred) {
                this.m_processLogger.output("There were errors, see " + this.m_errorFile + " for full details", 2);
                this.m_stderrWriter.write(formattedMessage);
                this.m_stderrWriter.flush();
                this.m_errorOccurred = true;
            }
            int summaryLength = 20;
            String summary = message.length() > 20 ? message.substring(0, 20) + "..." : message;
            this.outputInternal(state, "ERROR (\"" + summary + "\"), see error log for details", 1);
        }
    }

    static {
        s_currentTick = 0;
        s_lastTick = -1;
    }

    private final class ThreadState
    implements Logger,
    ThreadLogger {
        private final int m_threadNumber;
        private int m_currentRunNumber = -1;
        private int m_currentTestNumber = -1;
        private final StringBuffer m_buffer = new StringBuffer();
        private final char[] m_processOrThreadIDCharacters;
        private char[] m_currentRunNumberCharacters = null;

        public ThreadState(int threadNumber) {
            this.m_threadNumber = threadNumber;
            this.m_buffer.setLength(0);
            if (this.m_threadNumber == -1) {
                this.m_buffer.append(" (process ");
                this.m_buffer.append(LoggerImplementation.this.m_grinderID);
                this.m_buffer.append("): ");
            } else {
                this.m_buffer.append(" (thread ");
                this.m_buffer.append(this.m_threadNumber);
            }
            this.m_processOrThreadIDCharacters = this.getBufferCharacters(0);
        }

        private char[] getBufferCharacters(int start) {
            int length = this.m_buffer.length();
            char[] result = new char[length - start];
            this.m_buffer.getChars(start, length, result, 0);
            return result;
        }

        public int getThreadNumber() {
            return this.m_threadNumber;
        }

        public int getCurrentRunNumber() {
            return this.m_currentRunNumber;
        }

        public void setCurrentRunNumber(int runNumber) {
            if (runNumber != this.m_currentRunNumber) {
                this.m_currentRunNumberCharacters = null;
            }
            this.m_currentRunNumber = runNumber;
        }

        public int getCurrentTestNumber() {
            return this.m_currentTestNumber;
        }

        public void setCurrentTestNumber(int testNumber) {
            this.m_currentTestNumber = testNumber;
        }

        public void output(String message, int where) {
            LoggerImplementation.this.outputInternal(this, message, where);
        }

        public void output(String message) {
            this.output(message, 1);
        }

        public void error(String message, int where) {
            LoggerImplementation.this.errorInternal(this, message, where);
        }

        public void error(String message) {
            this.error(message, 1);
        }

        public PrintWriter getOutputLogWriter() {
            return LoggerImplementation.this.m_outputWriter;
        }

        public PrintWriter getErrorLogWriter() {
            return LoggerImplementation.this.m_errorWriter;
        }

        char[] formatMessage(String message) {
            this.m_buffer.setLength(0);
            this.m_buffer.append(LoggerImplementation.getDateString());
            this.m_buffer.append(this.m_processOrThreadIDCharacters);
            if (this.m_threadNumber != -1) {
                if (this.m_currentRunNumber >= 0) {
                    if (this.m_currentRunNumberCharacters == null) {
                        int start = this.m_buffer.length();
                        this.m_buffer.append(" run ");
                        this.m_buffer.append(Integer.toString(this.m_currentRunNumber));
                        this.m_currentRunNumberCharacters = this.getBufferCharacters(start);
                    } else {
                        this.m_buffer.append(this.m_currentRunNumberCharacters);
                    }
                }
                if (this.m_currentTestNumber >= 0) {
                    this.m_buffer.append(" test ");
                    this.m_buffer.append(Integer.toString(this.m_currentTestNumber));
                }
                this.m_buffer.append("): ");
            }
            this.m_buffer.append(message);
            this.m_buffer.append(s_lineSeparator);
            char[] result = new char[this.m_buffer.length()];
            this.m_buffer.getChars(0, result.length, result, 0);
            return result;
        }
    }

    private static final class ArchiveFileFilter
    implements FileFilter {
        private final String m_prefix;

        public ArchiveFileFilter(String prefix) {
            this.m_prefix = prefix;
        }

        public boolean accept(File file) {
            if (file.isFile() && file.getName().startsWith(this.m_prefix)) {
                try {
                    Integer.valueOf(file.getName().substring(this.m_prefix.length()));
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private final class FileManager {
        private final Writer m_outWriter;
        private final Writer m_errorWriter;
        private final File m_errorFile;
        private final Writer m_dataWriter;

        public FileManager(int numberOfOldLogs) throws EngineException {
            LoggerImplementation.this.m_logDirectory.mkdirs();
            if (!LoggerImplementation.this.m_logDirectory.canWrite()) {
                throw new EngineException("Cannot write to log directory '" + LoggerImplementation.this.m_logDirectory + "'");
            }
            this.m_errorFile = new File(LoggerImplementation.this.m_filenameFactory.createFilename("error"));
            File[] files = new File[]{new File(LoggerImplementation.this.m_filenameFactory.createFilename("out")), this.m_errorFile, new File(LoggerImplementation.this.m_filenameFactory.createFilename("data"))};
            int highestIndex = 0;
            for (int i = 0; i < files.length; ++i) {
                int keep = files[i].exists() ? Math.max(0, numberOfOldLogs - 1) : Math.max(0, numberOfOldLogs);
                highestIndex = Math.max(highestIndex, this.removeOldFiles(files[i].getName(), keep));
            }
            if (numberOfOldLogs > 0) {
                String suffix = s_fiveDigitFormat.format(highestIndex + 1);
                for (int i = 0; i < files.length; ++i) {
                    File newFile;
                    if (!files[i].exists() || files[i].renameTo(newFile = new File(files[i] + suffix))) continue;
                    throw new EngineException("Cannot rename '" + files[i] + "' to '" + newFile + "'");
                }
            }
            this.m_outWriter = this.createWriter(files[0]);
            this.m_errorWriter = this.createWriter(files[1]);
            this.m_dataWriter = this.createWriter(files[2]);
        }

        private int removeOldFiles(String prefix, int keep) throws EngineException {
            File[] files = LoggerImplementation.this.m_logDirectory.listFiles(new ArchiveFileFilter(prefix));
            if (files.length == 0) {
                return 0;
            }
            Arrays.sort(files, new Comparator(this){
                private final /* synthetic */ FileManager this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (int i = 0; i < files.length - keep; ++i) {
                if (files[i].delete()) continue;
                throw new EngineException("Cannot delete '" + files[i] + "'");
            }
            String lastFileName = files[files.length - 1].getName();
            return Integer.valueOf(lastFileName.substring(prefix.length()));
        }

        private Writer createWriter(File file) {
            return new BufferedWriter(new DelayedCreationFileWriter(file, false));
        }

        public Writer getOutWriter() {
            return this.m_outWriter;
        }

        public Writer getErrorWriter() {
            return this.m_errorWriter;
        }

        public File getErrorFile() {
            return this.m_errorFile;
        }

        public Writer getDataWriter() {
            return this.m_dataWriter;
        }
    }
}

