/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import org.python.core.PyBoolean;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.stringlib.FieldNameIterator$PyExposer;
import org.python.expose.ExposedType;

@ExposedType(name="fieldnameiterator", base=PyObject.class, isBaseType=false)
public class FieldNameIterator
extends PyObject {
    public static final PyType TYPE;
    private String markup;
    private Object head;
    private int index;

    public FieldNameIterator(String markup) {
        this.markup = markup;
        this.index = this.nextDotOrBracket(markup);
        String headStr = markup.substring(0, this.index);
        try {
            this.head = Integer.parseInt(headStr);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.head = headStr;
            return;
        }
    }

    @Override
    public PyObject __iter__() {
        FieldNameIterator fieldNameIterator = this;
        return fieldNameIterator;
    }

    final PyObject fieldnameiterator___iter__() {
        return this;
    }

    @Override
    public PyObject __iternext__() {
        return this.fieldnameiterator___iternext__();
    }

    final PyObject fieldnameiterator___iternext__() {
        Chunk chunk = this.nextChunk();
        if (chunk == null) {
            return null;
        }
        PyObject[] pyObjectArray = new PyObject[2];
        PyObject[] elements = pyObjectArray;
        pyObjectArray[0] = new PyBoolean(chunk.is_attr);
        elements[1] = chunk.value instanceof Integer ? new PyInteger((Integer)chunk.value) : new PyString((String)chunk.value);
        return new PyTuple(elements);
    }

    private int nextDotOrBracket(String markup) {
        int bracketPos;
        int dotPos = markup.indexOf(46, this.index);
        if (dotPos < 0) {
            dotPos = markup.length();
        }
        if ((bracketPos = markup.indexOf(91, this.index)) < 0) {
            bracketPos = markup.length();
        }
        return Math.min(dotPos, bracketPos);
    }

    public Object head() {
        return this.head;
    }

    public Chunk nextChunk() {
        if (this.index == this.markup.length()) {
            return null;
        }
        Chunk chunk = new Chunk();
        if (this.markup.charAt(this.index) == '[') {
            this.parseItemChunk(chunk);
        } else if (this.markup.charAt(this.index) == '.') {
            this.parseAttrChunk(chunk);
        } else {
            throw new IllegalArgumentException("Only '.' or '[' may follow ']' in format field specifier");
        }
        return chunk;
    }

    private void parseItemChunk(Chunk chunk) {
        chunk.is_attr = false;
        int endBracket = this.markup.indexOf(93, this.index + 1);
        if (endBracket < 0) {
            throw new IllegalArgumentException("Missing ']' in format string");
        }
        String itemValue = this.markup.substring(this.index + 1, endBracket);
        if (itemValue.length() == 0) {
            throw new IllegalArgumentException("Empty attribute in format string");
        }
        try {
            chunk.value = Integer.parseInt(itemValue);
        }
        catch (NumberFormatException numberFormatException) {
            chunk.value = itemValue;
        }
        this.index = endBracket + 1;
    }

    private void parseAttrChunk(Chunk chunk) {
        ++this.index;
        chunk.is_attr = true;
        int pos = this.nextDotOrBracket(this.markup);
        if (pos == this.index) {
            throw new IllegalArgumentException("Empty attribute in format string");
        }
        chunk.value = this.markup.substring(this.index, pos);
        this.index = pos;
    }

    static {
        PyType.addBuilder(FieldNameIterator.class, new FieldNameIterator$PyExposer());
        TYPE = PyType.fromClass(FieldNameIterator.class);
    }

    public static class Chunk {
        public boolean is_attr;
        public Object value;
    }
}

