/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.util.HashMap;
import java.util.Map;
import jnr.ffi.Pointer;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.ClosureManager;
import jnr.ffi.provider.jffi.NativeClosureFactory;
import jnr.ffi.provider.jffi.NativeRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeClosureManager
implements ClosureManager {
    private volatile Map<Class<? extends Object>, NativeClosureFactory> factories = new HashMap<Class<? extends Object>, NativeClosureFactory>();
    private final NativeRuntime runtime;
    private final TypeMapper typeMapper;

    NativeClosureManager(NativeRuntime runtime, TypeMapper typeMapper) {
        this.runtime = runtime;
        this.typeMapper = typeMapper;
    }

    @Override
    public final <T> T newClosure(Class<? extends T> closureClass, T instance) {
        this.factories.get(closureClass);
        return null;
    }

    final synchronized <T> NativeClosureFactory<T> getClosureFactory(Class<T> closureClass) {
        NativeClosureFactory factory = this.factories.get(closureClass);
        if (factory != null) {
            return factory;
        }
        factory = NativeClosureFactory.newClosureFactory(this.runtime, closureClass, this.typeMapper);
        this.factories.put(closureClass, factory);
        return factory;
    }

    static class 1 {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClosureSite<T>
    implements ToNativeConverter<T, Pointer> {
        private final NativeClosureFactory<T> factory;
        private NativeClosureFactory.ClosureReference closureReference = null;

        private ClosureSite(NativeClosureFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public final Pointer toNative(T value, ToNativeContext context) {
            NativeClosureFactory.ClosureReference closureReference;
            NativeClosureFactory.ClosureReference ref = this.closureReference;
            if (ref != null && (closureReference = ref).get() == value) {
                return ref.getPointer();
            }
            ref = this.factory.getClosureReference(value);
            if (this.closureReference == null || this.closureReference.get() == null) {
                this.closureReference = ref;
            }
            return ref.getPointer();
        }

        @Override
        public final Class<Pointer> nativeType() {
            return Pointer.class;
        }

        /* synthetic */ ClosureSite(NativeClosureFactory x0, byte by) {
            this(x0);
        }
    }
}

