/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jline.Terminal;

public class WindowsTerminal
extends Terminal {
    private Boolean directConsole;
    private String encoding = System.getProperty("jline.WindowsTerminal.input.encoding", System.getProperty("file.encoding"));
    private ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;
    private static /* synthetic */ Class class$jline$WindowsTerminal;

    public WindowsTerminal() {
        String dir = System.getProperty("jline.WindowsTerminal.directConsole");
        if ("true".equals(dir)) {
            this.directConsole = Boolean.TRUE;
        } else if ("false".equals(dir)) {
            this.directConsole = Boolean.FALSE;
        }
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private native int getConsoleMode();

    private native void setConsoleMode(int var1);

    private native int readByte();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    public final int readCharacter(InputStream in) throws IOException {
        if (this.directConsole == Boolean.FALSE) {
            return super.readCharacter(in);
        }
        if (this.directConsole == Boolean.TRUE || in == System.in || in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in) {
            return this.readByte();
        }
        return super.readCharacter(in);
    }

    /*
     * Unable to fully structure code
     */
    public final void initializeTerminal() throws Exception {
        block18: {
            var3_1 = "jline";
            var4_2 = (WindowsTerminal.class$jline$WindowsTerminal == null ? (WindowsTerminal.class$jline$WindowsTerminal = WindowsTerminal.class$("jline.WindowsTerminal")) : WindowsTerminal.class$jline$WindowsTerminal).getPackage().getImplementationVersion();
            if (var4_2 == null) {
                var4_2 = "";
            }
            var4_2 = var4_2.replace('.', '_');
            var5_3 = new File(System.getProperty("java.io.tmpdir"), var3_1 + "_" + var4_2 + ".dll");
            var6_4 = var5_3.isFile();
            var7_5 = 32;
            if (System.getProperty("os.arch").indexOf("64") != -1) {
                var7_5 = 64;
            }
            var8_6 = new BufferedInputStream((WindowsTerminal.class$jline$WindowsTerminal == null ? (WindowsTerminal.class$jline$WindowsTerminal = WindowsTerminal.class$("jline.WindowsTerminal")) : WindowsTerminal.class$jline$WindowsTerminal).getResourceAsStream(var3_1 + var7_5 + ".dll"));
            var9_7 = null;
            var9_7 = new BufferedOutputStream(new FileOutputStream(var5_3));
            var10_8 = new byte[10240];
            var11_10 = 0;
            while (var11_10 != -1) {
                var9_7.write(var10_8, 0, var11_10);
                var11_10 = var8_6.read(var10_8);
            }
            try {
                var9_7.close();
            }
            catch (IOException v0) {}
            break block18;
            catch (IOException var10_9) {
                try {
                    if (!var6_4) {
                        throw var10_9;
                    }
                    ** if (var9_7 == null) goto lbl-1000
                }
                catch (Throwable var12_11) {
                    if (var9_7 != null) {
                        try {
                            var9_7.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var12_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var9_7.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
        }
        var5_3.deleteOnExit();
        System.load(var5_3.getAbsolutePath());
        originalMode = this.getConsoleMode();
        this.setConsoleMode(originalMode & -5);
        newMode = originalMode & -16;
        this.setConsoleMode(newMode);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public final void start() {
                    WindowsTerminal.this.setConsoleMode(originalMode);
                }
            });
            return;
        }
        catch (AbstractMethodError v3) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readVirtualKey(InputStream in) throws IOException {
        int indicator = this.readCharacter(in);
        if (indicator == 224 || indicator == 0) {
            int key = this.readCharacter(in);
            switch (key) {
                case 72: {
                    return 16;
                }
                case 75: {
                    return 2;
                }
                case 77: {
                    return 6;
                }
                case 80: {
                    return 14;
                }
                case 83: {
                    return 127;
                }
                case 71: {
                    return 1;
                }
                case 79: {
                    return 5;
                }
                case 73: {
                    return 11;
                }
                case 81: {
                    return 12;
                }
                case 0: {
                    return 27;
                }
                case 82: {
                    return 3;
                }
            }
            return 0;
        }
        if (indicator <= 128) return indicator;
        InputStream inputStream = in;
        int n = indicator;
        ReplayPrefixOneCharInputStream replayPrefixOneCharInputStream = this.replayStream;
        this.replayStream.byteRead = 0;
        replayPrefixOneCharInputStream.firstByte = (byte)n;
        replayPrefixOneCharInputStream.wrappedStream = inputStream;
        replayPrefixOneCharInputStream.byteLength = 1;
        if (replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-8")) {
            ReplayPrefixOneCharInputStream replayPrefixOneCharInputStream2 = replayPrefixOneCharInputStream;
            if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFE0) == -64) {
                replayPrefixOneCharInputStream2.byteLength = 2;
                return this.replayReader.read();
            } else if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF0) == -32) {
                replayPrefixOneCharInputStream2.byteLength = 3;
                return this.replayReader.read();
            } else {
                if ((replayPrefixOneCharInputStream2.firstByte & 0xFFFFFFF8) != -16) throw new IOException("invalid UTF-8 first byte: " + replayPrefixOneCharInputStream2.firstByte);
                replayPrefixOneCharInputStream2.byteLength = 4;
            }
            return this.replayReader.read();
        } else if (replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-16")) {
            replayPrefixOneCharInputStream.byteLength = 2;
            return this.replayReader.read();
        } else {
            if (!replayPrefixOneCharInputStream.encoding.equalsIgnoreCase("UTF-32")) return this.replayReader.read();
            replayPrefixOneCharInputStream.byteLength = 4;
        }
        return this.replayReader.read();
    }

    public final boolean isSupported() {
        return true;
    }

    public final boolean isANSISupported() {
        return false;
    }

    public final boolean getEcho() {
        return false;
    }

    public final int getTerminalWidth() {
        return this.getWindowsTerminalWidth();
    }

    public final int getTerminalHeight() {
        return this.getWindowsTerminalHeight();
    }

    public final InputStream getDefaultBindings() {
        return (class$jline$WindowsTerminal == null ? (class$jline$WindowsTerminal = WindowsTerminal.class$("jline.WindowsTerminal")) : class$jline$WindowsTerminal).getResourceAsStream("windowsbindings.properties");
    }

    private static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding) {
            this.encoding = encoding;
        }

        public final int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public final int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

