/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import org.python.core.Py;
import org.python.modules.jffi.AllocatedDirectMemory;
import org.python.modules.jffi.BoundedNativeMemory;

class AllocatedNativeMemory
extends BoundedNativeMemory
implements AllocatedDirectMemory {
    private volatile boolean released = false;
    private volatile boolean autorelease = true;
    private final long storage;

    static final AllocatedNativeMemory allocate(int size, boolean clear) {
        return AllocatedNativeMemory.allocateAligned(size, 1, clear);
    }

    static final AllocatedNativeMemory allocateAligned(int size, int align, boolean clear) {
        long memory = MemoryIO.allocateMemory(size + align - 1, clear);
        if (memory == 0L) {
            throw Py.RuntimeError("failed to allocate " + size + " bytes");
        }
        return new AllocatedNativeMemory(memory, size, align);
    }

    private AllocatedNativeMemory(long address, int size, int align) {
        super((address - 1L & (long)(~(align - 1))) + (long)align, size);
        this.storage = address;
    }

    @Override
    public void free() {
        if (!this.released) {
            MemoryIO.freeMemory(this.storage);
            this.released = true;
        }
    }

    @Override
    public void setAutoRelease(boolean release) {
        this.autorelease = release;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.released && this.autorelease) {
                MemoryIO.freeMemory(this.storage);
                this.released = true;
            }
            return;
        }
        finally {
            super.finalize();
        }
    }
}

