/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public final class NImport
extends NNode {
    private List<NAlias> aliases;

    public NImport(List<NAlias> aliases) {
        this(null, 0, 1);
    }

    public NImport(List<NAlias> aliases, int start, int end) {
        super(start, end);
        this.aliases = aliases;
        this.addChildren(aliases);
    }

    @Override
    public final boolean bindsName() {
        return true;
    }

    @Override
    protected final void bindNames(Scope s) throws Exception {
        NImport.bindAliases(s, this.aliases);
    }

    static void bindAliases(Scope s, List<NAlias> aliases) throws Exception {
        NameBinder binder = NameBinder.make();
        for (NAlias a : aliases) {
            if (a.aname == null) continue;
            binder.bind(s, a.aname, (NType)new NUnknownType());
        }
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        Scope scope = s.getScopeSymtab();
        for (NAlias a : this.aliases) {
            NType modtype;
            NType nType = modtype = NImport.resolveExpr(a, s);
            if (!(modtype instanceof NModuleType)) continue;
            nType = modtype;
            NModuleType nModuleType = (NModuleType)nType;
            NAlias nAlias = a;
            Scope scope2 = scope;
            if (nAlias.aname != null) {
                if (nModuleType.getFile() != null) {
                    NameBinder.make().bind(scope2, nAlias.aname, (NType)nModuleType);
                } else {
                    scope2.update(nAlias.aname.id, new NUrl("http://docs.python.org/library/" + nModuleType.getTable().getPath() + ".html"), (NType)nModuleType, NBinding.Kind.SCOPE);
                }
            }
            NImport.addReferences(scope2, nAlias.qname, true);
        }
        return this.getType();
    }

    static void addReferences(Scope s, NQname qname, boolean putTopInScope) {
        while (qname != null) {
            NType nType = qname.getType();
            if (!(nType instanceof NModuleType)) {
                return;
            }
            nType = qname.getType();
            NModuleType mt = (NModuleType)nType;
            String modQname = mt.getTable().getPath();
            NBinding mb = Indexer.idx.lookupQname(modQname);
            if (mb == null) {
                mb = Indexer.idx.moduleTable.lookup(modQname);
            }
            if (mb == null) {
                Indexer.idx.putProblem(qname.getName(), "module not found");
                return;
            }
            Indexer.idx.putLocation(qname.getName(), mb);
            if (putTopInScope && qname.isTop()) {
                s.put(qname.getName().id, mb);
            }
            putTopInScope = false;
            qname = qname.getNext();
        }
        return;
    }

    public final String toString() {
        return "<Import:" + this.aliases + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NImport.visitNodeList(this.aliases, v);
        }
    }
}

