/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.collect.ComputationException;
import org.python.google.common.collect.MapMaker;
import org.python.google.common.collect.MapMakerInternalMap;

class ComputingConcurrentHashMap<K, V>
extends MapMakerInternalMap<K, V> {
    final Function<? super K, ? extends V> computingFunction;

    ComputingConcurrentHashMap(MapMaker builder, Function<? super K, ? extends V> computingFunction) {
        super(builder);
        this.computingFunction = CharMatcher.LookupTable.checkNotNull(computingFunction);
    }

    @Override
    final MapMakerInternalMap.Segment<K, V> createSegment(int initialCapacity, int maxSegmentSize) {
        return new ComputingSegment(this, initialCapacity, maxSegmentSize);
    }

    @Override
    final ComputingSegment<K, V> segmentFor(int hash) {
        return (ComputingSegment)super.segmentFor(hash);
    }

    final V getOrCompute(K key) throws ExecutionException {
        int hash = this.hash(CharMatcher.LookupTable.checkNotNull(key));
        return ((ComputingSegment)this.segmentFor(hash)).getOrCompute(key, hash, this.computingFunction);
    }

    static final class ComputingMapAdapter<K, V>
    extends ComputingConcurrentHashMap<K, V>
    implements Serializable {
        ComputingMapAdapter(MapMaker mapMaker, Function<? super K, ? extends V> computingFunction) {
            super(mapMaker, computingFunction);
        }

        @Override
        public final V get(Object key) {
            Object value;
            try {
                value = this.getOrCompute(key);
            }
            catch (ExecutionException executionException) {
                ExecutionException e = executionException;
                Throwable cause = executionException.getCause();
                Class<ComputationException> clazz = ComputationException.class;
                Throwable throwable = cause;
                if (cause != null && clazz.isInstance(throwable)) {
                    throw (Throwable)clazz.cast(throwable);
                }
                throw new ComputationException(cause);
            }
            if (value == null) {
                throw new NullPointerException(this.computingFunction + " returned null for key " + key + ".");
            }
            return value;
        }
    }

    static final class ComputingValueReference<K, V>
    implements MapMakerInternalMap.ValueReference<K, V> {
        private Function<? super K, ? extends V> computingFunction;
        @GuardedBy(value="ComputingValueReference.this")
        private volatile MapMakerInternalMap.ValueReference<K, V> computedReference = MapMakerInternalMap.unset();

        public ComputingValueReference(Function<? super K, ? extends V> computingFunction) {
            this.computingFunction = computingFunction;
        }

        @Override
        public final V get() {
            return null;
        }

        @Override
        public final MapMakerInternalMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final MapMakerInternalMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, @Nullable V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isComputingReference() {
            return true;
        }

        @Override
        public final V waitForValue() throws ExecutionException {
            if (this.computedReference == MapMakerInternalMap.UNSET) {
                boolean interrupted = false;
                try {
                    ComputingValueReference computingValueReference = this;
                    synchronized (computingValueReference) {
                        while (this.computedReference == MapMakerInternalMap.UNSET) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interrupted = true;
                            }
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.computedReference.waitForValue();
        }

        @Override
        public final void clear(MapMakerInternalMap.ValueReference<K, V> newValue) {
            this.setValueReference(newValue);
        }

        final V compute$1fb5a060(K key) throws ExecutionException {
            V value;
            try {
                value = this.computingFunction.apply(key);
            }
            catch (Throwable t) {
                this.setValueReference(new ComputationExceptionReference(t));
                throw new ExecutionException(t);
            }
            this.setValueReference(new ComputedReference(value));
            return value;
        }

        private void setValueReference(MapMakerInternalMap.ValueReference<K, V> valueReference) {
            ComputingValueReference computingValueReference = this;
            synchronized (computingValueReference) {
                if (this.computedReference == MapMakerInternalMap.UNSET) {
                    this.computedReference = valueReference;
                    this.notifyAll();
                }
                return;
            }
        }
    }

    static final class ComputedReference<K, V>
    implements MapMakerInternalMap.ValueReference<K, V> {
        private V value;

        ComputedReference(@Nullable V value) {
            this.value = value;
        }

        @Override
        public final V get() {
            return this.value;
        }

        @Override
        public final MapMakerInternalMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final MapMakerInternalMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final V waitForValue() {
            return this.get();
        }

        @Override
        public final void clear(MapMakerInternalMap.ValueReference<K, V> newValue) {
        }
    }

    static final class ComputationExceptionReference<K, V>
    implements MapMakerInternalMap.ValueReference<K, V> {
        private Throwable t;

        ComputationExceptionReference(Throwable t) {
            this.t = t;
        }

        @Override
        public final V get() {
            return null;
        }

        @Override
        public final MapMakerInternalMap.ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final MapMakerInternalMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isComputingReference() {
            return false;
        }

        @Override
        public final V waitForValue() throws ExecutionException {
            throw new ExecutionException(this.t);
        }

        @Override
        public final void clear(MapMakerInternalMap.ValueReference<K, V> newValue) {
        }
    }

    static final class ComputingSegment<K, V>
    extends MapMakerInternalMap.Segment<K, V> {
        ComputingSegment(MapMakerInternalMap<K, V> map, int initialCapacity, int maxSegmentSize) {
            super(map, initialCapacity, maxSegmentSize);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        final V getOrCompute(K key, int hash, Function<? super K, ? extends V> computingFunction) throws ExecutionException {
            try {
                Object v;
                MapMakerInternalMap.ReferenceEntry<? super K, ? extends V> e;
                Object value;
                do {
                    if ((e = this.getEntry(key, hash)) != null && (value = this.getLiveValue(e)) != null) {
                        this.recordRead(e);
                        v = value;
                        return v;
                    }
                    if (e == null || !e.getValueReference().isComputingReference()) {
                        ComputingValueReference<? super K, ? extends V> computingValueReference;
                        boolean createNewEntry;
                        block22: {
                            ComputingSegment computingSegment;
                            createNewEntry = true;
                            computingValueReference = null;
                            this.lock();
                            try {
                                MapMakerInternalMap.ReferenceEntry<? super K, ? extends V> first;
                                computingSegment = this;
                                computingSegment.runLockedCleanup();
                                int newCount = this.count - 1;
                                AtomicReferenceArray table = this.table;
                                int index = hash & table.length() - 1;
                                for (e = first = (MapMakerInternalMap.ReferenceEntry<? super K, ? extends V>)table.get(index); e != null; e = e.getNext()) {
                                    Object entryKey = e.getKey();
                                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                                    MapMakerInternalMap.ValueReference valueReference = e.getValueReference();
                                    if (valueReference.isComputingReference()) {
                                        createNewEntry = false;
                                        break;
                                    }
                                    Object value2 = e.getValueReference().get();
                                    if (value2 == null) {
                                        this.enqueueNotification$15c8a27f(entryKey, value2, MapMaker.RemovalCause.COLLECTED);
                                    } else if (this.map.expires() && this.map.isExpired(e)) {
                                        this.enqueueNotification$15c8a27f(entryKey, value2, MapMaker.RemovalCause.EXPIRED);
                                    } else {
                                        this.recordLockedRead(e);
                                        Object v2 = value2;
                                        return v2;
                                    }
                                    this.evictionQueue.remove(e);
                                    this.expirationQueue.remove(e);
                                    this.count = newCount;
                                    break;
                                }
                                if (!createNewEntry) break block22;
                                computingValueReference = new ComputingValueReference<K, V>(computingFunction);
                                if (e == null) {
                                    e = this.newEntry(key, hash, first);
                                    e.setValueReference(computingValueReference);
                                    table.set(index, e);
                                } else {
                                    e.setValueReference(computingValueReference);
                                }
                            }
                            finally {
                                this.unlock();
                                computingSegment = this;
                                computingSegment.runUnlockedCleanup();
                            }
                        }
                        if (createNewEntry) {
                            V v3 = this.compute(key, hash, e, computingValueReference);
                            return v3;
                        }
                    }
                    CharMatcher.LookupTable.checkState(!Thread.holdsLock(e), "Recursive computation");
                } while ((value = e.getValueReference().waitForValue()) == null);
                this.recordRead(e);
                v = value;
                return v;
            }
            finally {
                this.postReadCleanup();
            }
        }

        private V compute(K key, int hash, MapMakerInternalMap.ReferenceEntry<K, V> e, ComputingValueReference<K, V> computingValueReference) throws ExecutionException {
            Object value = null;
            System.nanoTime();
            long end = 0L;
            try {
                Object oldValue;
                MapMakerInternalMap.ReferenceEntry<K, V> referenceEntry = e;
                synchronized (referenceEntry) {
                    value = computingValueReference.compute$1fb5a060(key);
                    end = System.nanoTime();
                }
                if (value != null && (oldValue = this.put(key, hash, value, true)) != null) {
                    this.enqueueNotification$15c8a27f(key, value, MapMaker.RemovalCause.REPLACED);
                }
                referenceEntry = value;
                return (V)referenceEntry;
            }
            finally {
                if (end == 0L) {
                    System.nanoTime();
                }
                if (value == null) {
                    this.clearValue(key, hash, computingValueReference);
                }
            }
        }
    }
}

