/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.antlr.ParseException;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Pragma;
import org.python.core.PragmaReceiver;

public enum FutureFeature implements Pragma
{
    nested_scopes(CodeFlag.CO_NESTED),
    division(CodeFlag.CO_FUTURE_DIVISION),
    generators(CodeFlag.CO_GENERATOR_ALLOWED),
    absolute_import(CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT),
    with_statement(CodeFlag.CO_FUTURE_WITH_STATEMENT),
    print_function(CodeFlag.CO_FUTURE_PRINT_FUNCTION),
    unicode_literals(CodeFlag.CO_FUTURE_UNICODE_LITERALS),
    braces{

        @Override
        public final void addTo(PragmaReceiver features) {
            throw new ParseException("not a chance");
        }
    }
    ,
    GIL{

        @Override
        public final void addTo(PragmaReceiver features) {
            throw new ParseException("Never going to happen!");
        }
    }
    ,
    global_interpreter_lock{

        @Override
        public final void addTo(PragmaReceiver features) {
            GIL.addTo(features);
        }
    };

    public static final String MODULE_NAME = "__future__";
    public static final Pragma.PragmaModule PRAGMA_MODULE;
    private final CodeFlag flag;

    private FutureFeature(CodeFlag flag) {
        this.flag = flag;
    }

    private FutureFeature() {
        this(null);
    }

    @Override
    public void addTo(PragmaReceiver features) {
        features.add(this);
    }

    public static void addFeature(String featureName, PragmaReceiver features) {
        FutureFeature.getFeature(featureName).addTo(features);
    }

    private static FutureFeature getFeature(String featureName) {
        try {
            return FutureFeature.valueOf(featureName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("future feature " + featureName + " is not defined");
        }
    }

    public void setFlag(CompilerFlags cflags) {
        if (this.flag != null) {
            cflags.setFlag(this.flag);
        }
    }

    /* synthetic */ FutureFeature(String x0, int x1, byte by) {
        this();
    }

    static {
        PRAGMA_MODULE = new Pragma.PragmaModule(MODULE_NAME){

            @Override
            public final Pragma getPragma(String name) {
                return FutureFeature.getFeature(name);
            }

            @Override
            public final Pragma getStarPragma() {
                throw new ParseException("future feature * is not defined");
            }
        };
    }
}

