/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NType;

public final class NDict
extends NNode {
    private List<NNode> keys;
    private List<NNode> values;

    public NDict(List<NNode> keys, List<NNode> values) {
        this(null, null, 0, 1);
    }

    public NDict(List<NNode> keys, List<NNode> values, int start, int end) {
        super(start, end);
        this.keys = keys;
        this.values = values;
        this.addChildren(keys);
        this.addChildren(values);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType keyType = NDict.resolveListAsUnion(this.keys, s);
        NType valType = NDict.resolveListAsUnion(this.values, s);
        return this.setType(new NDictType(keyType, valType));
    }

    public final String toString() {
        return "<Dict>";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NDict.visitNodeList(this.keys, v);
            NDict.visitNodeList(this.values, v);
        }
    }
}

