/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.util.concurrent;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.python.google.common.base.CharMatcher;

public final class ExecutionList {
    private static final Logger log = Logger.getLogger(ExecutionList.class.getName());
    private final Queue<RunnableExecutorPair> runnables = new LinkedList<RunnableExecutorPair>();
    private boolean executed = false;

    public final void add(Runnable runnable, Executor executor) {
        CharMatcher.LookupTable.checkNotNull(runnable, "Runnable was null.");
        CharMatcher.LookupTable.checkNotNull(executor, "Executor was null.");
        boolean executeImmediate = false;
        Queue<RunnableExecutorPair> queue = this.runnables;
        synchronized (queue) {
            if (!this.executed) {
                this.runnables.add(new RunnableExecutorPair(runnable, executor));
            } else {
                executeImmediate = true;
            }
        }
        if (executeImmediate) {
            new RunnableExecutorPair(runnable, executor).execute();
        }
    }

    public final void execute() {
        Queue<RunnableExecutorPair> queue = this.runnables;
        synchronized (queue) {
            if (this.executed) {
                return;
            }
            this.executed = true;
        }
        while (!this.runnables.isEmpty()) {
            this.runnables.poll().execute();
        }
    }

    static final class RunnableExecutorPair {
        private Runnable runnable;
        private Executor executor;

        RunnableExecutorPair(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        final void execute() {
            try {
                this.executor.execute(this.runnable);
                return;
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + this.runnable + " with executor " + this.executor, e);
                return;
            }
        }
    }
}

