/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.NativeMethods;
import com.kenai.jffi.PageManager;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.ffi.Platform;
import jnr.ffi.provider.jffi.MemoryUtil;
import jnr.ffi.provider.jffi.StubCompiler;
import jnr.ffi.provider.jffi.X86Disassembler;
import jnr.x86asm.Assembler;

abstract class AbstractX86StubCompiler
extends StubCompiler {
    public static final boolean DEBUG = Boolean.getBoolean("jnr.ffi.compile.dump");
    final List<Stub> stubs = new LinkedList<Stub>();

    AbstractX86StubCompiler() {
    }

    final void attach(Class clazz) {
        long npages;
        if (this.stubs.isEmpty()) {
            return;
        }
        long codeSize = 0L;
        for (Stub stub : this.stubs) {
            codeSize += (long)(stub.assembler.codeSize() + 8);
        }
        PageManager pm = PageManager.getInstance();
        long code = pm.allocatePages((int)(npages = (codeSize + pm.pageSize() - 1L) / pm.pageSize()), 3);
        if (code == 0L) {
            throw new OutOfMemoryError("allocatePages failed for codeSize=" + codeSize);
        }
        PageHolder page = new PageHolder(pm, code, npages);
        ArrayList<NativeMethod> methods = new ArrayList<NativeMethod>(this.stubs.size());
        long fn = code;
        PrintStream dbg = System.err;
        System.out.flush();
        System.err.flush();
        for (Stub stub : this.stubs) {
            Assembler asm = stub.assembler;
            long l = 8L;
            long l2 = fn;
            fn = l2 + 8L - 1L & 0xFFFFFFFFFFFFFFF8L;
            ByteBuffer buf = ByteBuffer.allocate(asm.codeSize()).order(ByteOrder.LITTLE_ENDIAN);
            stub.assembler.relocCode(buf, fn);
            buf.flip();
            MemoryIO.getInstance();
            MemoryIO.putByteArray(fn, buf.array(), buf.arrayOffset(), buf.limit());
            if (DEBUG && X86Disassembler.isAvailable()) {
                dbg.println(clazz.getName() + "." + stub.name + " " + stub.signature);
                X86Disassembler disassembler = X86Disassembler.create();
                disassembler.setMode(Platform.getNativePlatform().getCPU() == Platform.CPU.I386 ? X86Disassembler.Mode.I386 : X86Disassembler.Mode.X86_64);
                disassembler.setSyntax(X86Disassembler.Syntax.INTEL);
                disassembler.setInputBuffer(MemoryUtil.newPointer(fn), asm.offset());
                while (disassembler.disassemble()) {
                    dbg.printf("%8x: %s\n", disassembler.offset(), disassembler.insn());
                }
                if (buf.remaining() > asm.offset()) {
                    dbg.printf("%8x: <indirect call trampolines>\n", asm.offset());
                }
                dbg.println();
            }
            methods.add(new NativeMethod(fn, stub.name, stub.signature));
            fn += (long)asm.codeSize();
        }
        pm.protectPages(code, (int)npages, 5);
        NativeMethods.register(clazz, methods);
        StaticDataHolder.PAGES.put(clazz, page);
    }

    private static long align(long offset, long align) {
        return offset + 8L - 1L & 0xFFFFFFFFFFFFFFF8L;
    }

    static final class PageHolder {
        private PageManager pm;
        private long memory;
        private long pageCount;

        public PageHolder(PageManager pm, long memory, long pageCount) {
            this.pm = pm;
            this.memory = memory;
            this.pageCount = pageCount;
        }

        protected final void finalize() throws Throwable {
            try {
                this.pm.freePages(this.memory, (int)this.pageCount);
                return;
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing native pages: %s", t.getLocalizedMessage());
                return;
            }
            finally {
                super.finalize();
            }
        }
    }

    static final class Stub {
        final String name;
        final String signature;
        final Assembler assembler;

        public Stub(String name, String signature, Assembler assembler) {
            this.name = name;
            this.signature = signature;
            this.assembler = assembler;
        }
    }

    static final class StaticDataHolder {
        static final Map<Class, PageHolder> PAGES = Collections.synchronizedMap(new WeakHashMap());

        private StaticDataHolder() {
        }
    }
}

