/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContextCache$SingletonHolder;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CallContext {
    final long contextAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    private final Foreign foreign = Foreign.getInstance();

    public static CallContext getCallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        return CallContextCache$SingletonHolder.INSTANCE$62852ea7.getCallContext(returnType, parameterTypes, convention, saveErrno);
    }

    public CallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0);
        long h = this.foreign.newCallContext(returnType.handle(), Type.nativeHandles(parameterTypes), flags);
        if (h == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h;
        parameterTypes.clone();
        this.parameterCount = parameterTypes.length;
        this.rawParameterSize = this.foreign.getCallContextRawParameterSize(h);
        Type.nativeHandles(parameterTypes);
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L) {
                this.foreign.freeCallContext(this.contextAddress);
            }
            return;
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "exception when freeing " + this.getClass() + ": %s", t.getLocalizedMessage());
            return;
        }
        finally {
            super.finalize();
        }
    }
}

