/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process.jython;

import java.lang.reflect.Field;
import net.grinder.common.Test;
import net.grinder.common.UncheckedGrinderException;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.engine.process.ScriptEngine;
import net.grinder.engine.process.jython.InstrumentedPyInstance;
import net.grinder.engine.process.jython.InstrumentedPyJavaClass;
import net.grinder.engine.process.jython.InstrumentedPyJavaInstanceForJavaInstances;
import net.grinder.engine.process.jython.InstrumentedPyJavaInstanceForPyFunctions;
import net.grinder.engine.process.jython.InstrumentedPyJavaInstanceForPyMethods;
import net.grinder.engine.process.jython.InstrumentedPyReflectedFunction;
import net.grinder.engine.process.jython.JythonScriptExecutionException;
import net.grinder.script.NotWrappableTypeException;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public final class JythonScriptEngine
implements ScriptEngine {
    private static final String TEST_RUNNER_CALLABLE_NAME = "TestRunner";
    private final PySystemState m_systemState;
    private final PythonInterpreter m_interpreter;
    private final JythonVersionAdapter m_versionAdapter;
    private final PyInstrumentedProxyFactory m_instrumentedProxyFactory;
    private PyObject m_testRunnerFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$python$core$PyObject;
    static /* synthetic */ Class class$org$python$core$PyInstance;

    public JythonScriptEngine() throws EngineException {
        PySystemState.initialize();
        this.m_systemState = new PySystemState();
        this.m_interpreter = new PythonInterpreter(null, this.m_systemState);
        this.m_versionAdapter = new JythonVersionAdapter();
        this.m_instrumentedProxyFactory = new PyInstrumentedProxyFactory();
    }

    public void initialise(ScriptLocation script) throws EngineException {
        this.m_systemState.path.insert(0, (PyObject)new PyString(script.getDirectory().getFile().getPath()));
        try {
            this.m_interpreter.execfile(script.getFile().getPath());
        }
        catch (PyException e) {
            throw new JythonScriptExecutionException("initialising test script", e);
        }
        this.m_testRunnerFactory = this.m_interpreter.get(TEST_RUNNER_CALLABLE_NAME);
        if (this.m_testRunnerFactory == null || !this.m_testRunnerFactory.isCallable()) {
            throw new JythonScriptExecutionException("There is no callable (class or function) named 'TestRunner' in " + script);
        }
    }

    public ScriptEngine.WorkerRunnable createWorkerRunnable() throws EngineException {
        return new JythonWorkerRunnable();
    }

    public ScriptEngine.WorkerRunnable createWorkerRunnable(Object testRunner) throws EngineException {
        PyObject pyTestRunner;
        if (testRunner instanceof PyObject && (pyTestRunner = (PyObject)testRunner).isCallable()) {
            return new JythonWorkerRunnable(pyTestRunner);
        }
        throw new JythonScriptExecutionException("testRunner object is not callable");
    }

    public Object createInstrumentedProxy(Test test, ScriptEngine.Dispatcher dispatcher, Object o) throws NotWrappableTypeException {
        return this.m_instrumentedProxyFactory.instrumentObject(test, new PyDispatcher(dispatcher), o);
    }

    public void shutdown() throws EngineException {
        PyObject exitfunc = this.m_systemState.__findattr__("exitfunc");
        if (exitfunc != null) {
            try {
                exitfunc.__call__();
            }
            catch (PyException e) {
                throw new JythonScriptExecutionException("calling script exit function", e);
            }
        }
    }

    public String getDescription() {
        return "Jython " + PySystemState.version;
    }

    static final class PyDispatcher {
        private final ScriptEngine.Dispatcher m_delegate;

        private PyDispatcher(ScriptEngine.Dispatcher delegate) {
            this.m_delegate = delegate;
        }

        public PyObject dispatch(ScriptEngine.Dispatcher.Callable callable) {
            try {
                return (PyObject)this.m_delegate.dispatch(callable);
            }
            catch (UncheckedGrinderException e) {
                throw e;
            }
            catch (Exception e) {
                throw Py.JavaError((Throwable)e);
            }
        }
    }

    static class JythonVersionAdapter {
        private final Field m_instanceClassField;
        private final PyClass m_dieQuietly = PyJavaClass.lookup((Class)(class$java$lang$Object == null ? (class$java$lang$Object = JythonScriptEngine.class$("java.lang.Object")) : class$java$lang$Object));

        public JythonVersionAdapter() throws EngineException {
            Field f;
            try {
                f = (class$org$python$core$PyObject == null ? (class$org$python$core$PyObject = JythonScriptEngine.class$("org.python.core.PyObject")) : class$org$python$core$PyObject).getField("__class__");
            }
            catch (NoSuchFieldException e) {
                try {
                    f = (class$org$python$core$PyInstance == null ? (class$org$python$core$PyInstance = JythonScriptEngine.class$("org.python.core.PyInstance")) : class$org$python$core$PyInstance).getField("instclass");
                }
                catch (NoSuchFieldException e2) {
                    throw new EngineException("Incompatible Jython release in classpath");
                }
            }
            this.m_instanceClassField = f;
        }

        public void disableDel(PyObject pyObject) {
            try {
                this.m_instanceClassField.set(pyObject, this.m_dieQuietly);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public PyClass getClassForInstance(PyInstance target) {
            try {
                return (PyClass)this.m_instanceClassField.get(target);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private final class JythonWorkerRunnable
    implements ScriptEngine.WorkerRunnable {
        private final PyObject m_testRunner;

        private JythonWorkerRunnable() throws EngineException {
            try {
                this.m_testRunner = JythonScriptEngine.this.m_testRunnerFactory.__call__();
            }
            catch (PyException e) {
                throw new JythonScriptExecutionException("creating per-thread TestRunner object", e);
            }
            if (!this.m_testRunner.isCallable()) {
                throw new JythonScriptExecutionException("The result of 'TestRunner()' is not callable");
            }
        }

        public JythonWorkerRunnable(PyObject testRunner) {
            this.m_testRunner = testRunner;
        }

        public void run() throws ScriptEngine.ScriptExecutionException {
            try {
                this.m_testRunner.__call__();
            }
            catch (PyException e) {
                throw new JythonScriptExecutionException("calling TestRunner", e);
            }
        }

        public void shutdown() throws ScriptEngine.ScriptExecutionException {
            PyObject del = this.m_testRunner.__findattr__("__del__");
            if (del != null) {
                try {
                    del.__call__();
                }
                catch (PyException e) {
                    throw new JythonScriptExecutionException("deleting TestRunner instance", e);
                }
                finally {
                    JythonScriptEngine.this.m_versionAdapter.disableDel(this.m_testRunner);
                }
            }
        }
    }

    private class PyInstrumentedProxyFactory {
        private PyInstrumentedProxyFactory() {
        }

        public PyObject instrumentObject(Test test, PyDispatcher pyDispatcher, Object o) throws NotWrappableTypeException {
            if (o instanceof PyObject) {
                if (o instanceof PyInstance) {
                    PyInstance pyInstance = (PyInstance)o;
                    PyClass pyClass = JythonScriptEngine.this.m_versionAdapter.getClassForInstance(pyInstance);
                    return new InstrumentedPyInstance(test, pyClass, pyInstance, pyDispatcher);
                }
                if (o instanceof PyFunction) {
                    return new InstrumentedPyJavaInstanceForPyFunctions(test, (PyFunction)o, pyDispatcher);
                }
                if (o instanceof PyMethod) {
                    return new InstrumentedPyJavaInstanceForPyMethods(test, (PyMethod)o, pyDispatcher);
                }
                if (o instanceof PyReflectedFunction) {
                    return new InstrumentedPyReflectedFunction(test, (PyReflectedFunction)o, pyDispatcher);
                }
            } else {
                if (o instanceof PyProxy) {
                    PyInstance pyInstance = ((PyProxy)o)._getPyInstance();
                    PyClass pyClass = JythonScriptEngine.this.m_versionAdapter.getClassForInstance(pyInstance);
                    return new InstrumentedPyInstance(test, pyClass, pyInstance, pyDispatcher);
                }
                if (o == null) {
                    throw new NotWrappableTypeException("Can't wrap null/None");
                }
                if (o instanceof Class) {
                    return new InstrumentedPyJavaClass(test, (Class)o, pyDispatcher);
                }
                Class<?> c = o.getClass();
                if (!(c.isArray() || o instanceof Number || o instanceof String)) {
                    return new InstrumentedPyJavaInstanceForJavaInstances(test, o, pyDispatcher);
                }
            }
            throw new NotWrappableTypeException(o.getClass().getName());
        }
    }
}

