/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.thread;

import java.util.LinkedList;
import net.grinder.common.GrinderException;
import net.grinder.common.UncheckedInterruptedException;
import net.grinder.util.thread.Condition;

public final class ThreadSafeQueue {
    private final LinkedList m_messages = new LinkedList();
    private final Condition m_condition = new Condition();
    private volatile boolean m_shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Object item) throws ShutdownException {
        Condition condition = this.getCondition();
        synchronized (condition) {
            this.checkIfShutdown();
            this.m_messages.add(item);
            this.getCondition().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(boolean block) throws ShutdownException {
        Condition condition = this.getCondition();
        synchronized (condition) {
            while (!this.m_shutdown && block && this.m_messages.size() == 0) {
                try {
                    this.getCondition().wait();
                }
                catch (InterruptedException e) {
                    this.shutdown();
                    throw new UncheckedInterruptedException(e);
                }
            }
            this.checkIfShutdown();
            if (this.m_messages.size() == 0) {
                return null;
            }
            this.getCondition().notifyAll();
            return this.m_messages.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Condition condition = this.getCondition();
        synchronized (condition) {
            this.m_shutdown = true;
            this.m_messages.clear();
            this.getCondition().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown() {
        Condition condition = this.getCondition();
        synchronized (condition) {
            while (this.getSize() > 0) {
                this.getCondition().waitNoInterrruptException();
            }
            this.shutdown();
        }
    }

    public Condition getCondition() {
        return this.m_condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Condition condition = this.getCondition();
        synchronized (condition) {
            return this.m_messages.size();
        }
    }

    public void checkIfShutdown() throws ShutdownException {
        if (this.m_shutdown) {
            throw new ShutdownException("ThreadSafeQueue shutdown");
        }
    }

    public static final class ShutdownException
    extends GrinderException {
        private ShutdownException(String s) {
            super(s);
        }
    }
}

