/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.statistics;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.TreeMap;
import net.grinder.common.AbstractTestSemantics;
import net.grinder.common.Test;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.statistics.StatisticsSetImplementation;

public final class TestStatisticsMap
implements Externalizable {
    private static final long serialVersionUID = 3L;
    private final transient StatisticsSetFactory m_statisticsSetFactory;
    private final Map m_data = new TreeMap();

    public TestStatisticsMap(StatisticsSetFactory statisticsSetFactory) {
        this.m_statisticsSetFactory = statisticsSetFactory;
    }

    public TestStatisticsMap() {
        this(StatisticsServicesImplementation.getInstance().getStatisticsSetFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Test test, StatisticsSet statistics) {
        if (!(statistics instanceof StatisticsSetImplementation)) {
            throw new AssertionError((Object)"StatisticsSet implementation not supported");
        }
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            this.m_data.put(test, statistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            return this.m_data.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TestStatisticsMap other) {
        TestStatisticsMap testStatisticsMap = other;
        synchronized (testStatisticsMap) {
            Iterator otherIterator = other.new Iterator();
            while (otherIterator.hasNext()) {
                StatisticsSet statistics;
                Pair othersPair = otherIterator.next();
                TestStatisticsMap testStatisticsMap2 = this;
                synchronized (testStatisticsMap2) {
                    StatisticsSet existingStatistics = (StatisticsSet)this.m_data.get(othersPair.getTest());
                    if (existingStatistics == null) {
                        statistics = this.m_statisticsSetFactory.create();
                        this.put(othersPair.getTest(), statistics);
                    } else {
                        statistics = existingStatistics;
                    }
                }
                statistics.add(othersPair.getStatistics());
            }
        }
    }

    public TestStatisticsMap reset() {
        final TestStatisticsMap result = new TestStatisticsMap(this.m_statisticsSetFactory);
        new ForEach(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void next(Test test, StatisticsSet statistics) {
                StatisticsSet snapshot;
                StatisticsSet statisticsSet = statistics;
                synchronized (statisticsSet) {
                    snapshot = statistics.snapshot();
                    statistics.reset();
                }
                if (!snapshot.isZero()) {
                    result.put(test, snapshot);
                }
            }
        }.iterate();
        return result;
    }

    public StatisticsSet nonCompositeStatisticsTotals() {
        final StatisticsSet result = this.m_statisticsSetFactory.create();
        new ForEach(){

            public void next(Test test, StatisticsSet statistics) {
                if (!statistics.isComposite()) {
                    result.add(statistics);
                }
            }
        }.iterate();
        return result;
    }

    public StatisticsSet compositeStatisticsTotals() {
        final StatisticsSet result = this.m_statisticsSetFactory.create();
        new ForEach(){

            public void next(Test test, StatisticsSet statistics) {
                if (statistics.isComposite()) {
                    result.add(statistics);
                }
            }
        }.iterate();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != TestStatisticsMap.class) {
            return false;
        }
        TestStatisticsMap otherMap = (TestStatisticsMap)o;
        if (this.m_data.size() != otherMap.m_data.size()) {
            return false;
        }
        Iterator iterator = new Iterator();
        Iterator otherIterator = otherMap.new Iterator();
        while (iterator.hasNext()) {
            Pair pair = iterator.next();
            Pair otherPair = otherIterator.next();
            if (pair.getTest().equals(otherPair.getTest()) && pair.getStatistics().equals(otherPair.getStatistics())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        final StringBuffer result = new StringBuffer();
        result.append("TestStatisticsMap = {");
        new ForEach(){

            public void next(Test test, StatisticsSet statisticsSet) {
                result.append("(");
                result.append(test);
                result.append(", ");
                result.append(statisticsSet);
                result.append(")");
            }
        }.iterate();
        result.append("}");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        TestStatisticsMap testStatisticsMap = this;
        synchronized (testStatisticsMap) {
            out.writeInt(this.m_data.size());
            Iterator iterator = new Iterator();
            while (iterator.hasNext()) {
                Pair pair = iterator.next();
                out.writeInt(pair.getTest().getNumber());
                this.m_statisticsSetFactory.writeStatisticsExternal(out, (StatisticsSetImplementation)pair.getStatistics());
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException {
        int n = in.readInt();
        this.m_data.clear();
        for (int i = 0; i < n; ++i) {
            this.m_data.put(new LightweightTest(in.readInt()), this.m_statisticsSetFactory.readStatisticsExternal(in));
        }
    }

    public abstract class ForEach {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void iterate() {
            TestStatisticsMap testStatisticsMap = TestStatisticsMap.this;
            synchronized (testStatisticsMap) {
                Iterator iterator = new Iterator();
                while (iterator.hasNext()) {
                    Pair pair = iterator.next();
                    this.next(pair.getTest(), pair.getStatistics());
                }
            }
        }

        protected abstract void next(Test var1, StatisticsSet var2);
    }

    public static final class Pair {
        private final Test m_test;
        private final StatisticsSet m_statistics;

        private Pair(Test test, StatisticsSet statistics) {
            this.m_test = test;
            this.m_statistics = statistics;
        }

        public Test getTest() {
            return this.m_test;
        }

        public StatisticsSet getStatistics() {
            return this.m_statistics;
        }
    }

    public final class Iterator {
        private final java.util.Iterator m_iterator;

        public Iterator() {
            this.m_iterator = TestStatisticsMap.this.m_data.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        public Pair next() {
            Map.Entry entry = (Map.Entry)this.m_iterator.next();
            Test test = (Test)entry.getKey();
            StatisticsSet statistics = (StatisticsSet)entry.getValue();
            return new Pair(test, statistics);
        }
    }

    private static final class LightweightTest
    extends AbstractTestSemantics {
        private final int m_number;

        public LightweightTest(int number) {
            this.m_number = number;
        }

        public int getNumber() {
            return this.m_number;
        }

        public String getDescription() {
            return "";
        }
    }
}

