/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.File;
import net.grinder.common.FilenameFactory;

final class FilenameFactoryImplementation
implements FilenameFactory {
    private final String m_logDirectory;
    private final String m_contextString;

    FilenameFactoryImplementation(File logDirectory, String grinderID) {
        this(logDirectory.getPath(), "_" + grinderID);
    }

    private FilenameFactoryImplementation(String logDirectory, String contextString) {
        this.m_logDirectory = logDirectory;
        this.m_contextString = contextString;
    }

    FilenameFactoryImplementation createSubContextFilenameFactory(String subContext) {
        return new FilenameFactoryImplementation(this.m_logDirectory, this.m_contextString + "_" + subContext);
    }

    public String createFilename(String prefix, String suffix) {
        StringBuffer result = new StringBuffer();
        result.append(this.m_logDirectory);
        result.append(File.separator);
        result.append(prefix);
        result.append(this.m_contextString);
        result.append(suffix);
        return result.toString();
    }

    public String createFilename(String prefix) {
        return this.createFilename(prefix, ".log");
    }
}

