/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.Log;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Date;

public class Cookie
implements Serializable {
    private static final long serialVersionUID = 8599975325569296615L;
    protected String name;
    protected String value;
    protected Date expires;
    protected String domain;
    protected String path;
    protected boolean secure;

    public Cookie(String name, String value, String domain, String path, Date expires, boolean secure) {
        if (name == null) {
            throw new NullPointerException("missing name");
        }
        if (value == null) {
            throw new NullPointerException("missing value");
        }
        if (domain == null) {
            throw new NullPointerException("missing domain");
        }
        if (path == null) {
            throw new NullPointerException("missing path");
        }
        this.name = name;
        this.value = value;
        this.domain = domain.toLowerCase();
        this.path = path;
        this.expires = expires;
        this.secure = secure;
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
    }

    protected Cookie(RoRequest req) {
        this.name = null;
        this.value = null;
        this.expires = null;
        this.domain = req.getConnection().getHost();
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.path = Util.getPath(req.getRequestURI());
        int slash = this.path.lastIndexOf(47);
        if (slash >= 0) {
            this.path = this.path.substring(0, slash);
        }
        this.secure = false;
    }

    protected static Cookie[] parse(String set_cookie, RoRequest req) throws ProtocolException {
        int beg = 0;
        int end2 = 0;
        int start = 0;
        if (set_cookie.indexOf("HttpOnly") != -1) {
            set_cookie = set_cookie.replaceAll(";\\s*HttpOnly,", ";,");
            set_cookie = set_cookie.replaceAll(";\\s*HttpOnly$", ";");
        }
        char[] buf = set_cookie.toCharArray();
        int len = buf.length;
        Cookie[] cookie_arr = new Cookie[]{};
        while ((beg = Util.skipSpace(buf, beg)) < len) {
            int eq;
            if (buf[beg] == ',') {
                ++beg;
                continue;
            }
            Cookie curr = new Cookie(req);
            start = beg;
            end2 = set_cookie.indexOf(61, beg);
            if (end2 == -1) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
            }
            curr.name = set_cookie.substring(beg, end2).trim();
            beg = Util.skipSpace(buf, end2 + 1);
            int comma = set_cookie.indexOf(44, beg);
            int semic = set_cookie.indexOf(59, beg);
            end2 = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : (comma > semic ? semic : ((eq = set_cookie.indexOf(61, comma)) > 0 && eq < semic ? set_cookie.lastIndexOf(44, eq) : semic))));
            curr.value = set_cookie.substring(beg, end2).trim();
            beg = end2;
            boolean legal = true;
            while (beg < len && buf[beg] != ',') {
                if (buf[beg] == ';') {
                    beg = Util.skipSpace(buf, beg + 1);
                    continue;
                }
                if (beg + 6 <= len && set_cookie.regionMatches(true, beg, "secure", 0, 6)) {
                    curr.secure = true;
                    beg += 6;
                    if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == ';') {
                        beg = Util.skipSpace(buf, beg + 1);
                        continue;
                    }
                    if (beg >= len || buf[beg] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nExpected " + "';' or ',' at position " + beg);
                }
                end2 = set_cookie.indexOf(61, beg);
                if (end2 == -1) {
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
                }
                String name = set_cookie.substring(beg, end2).trim();
                beg = Util.skipSpace(buf, end2 + 1);
                if (name.equalsIgnoreCase("expires")) {
                    int pos;
                    if (beg >= len) break;
                    if (set_cookie.charAt(beg) == '\"') {
                        beg = Util.skipSpace(buf, beg + 1);
                    }
                    for (pos = beg; pos < len && (buf[pos] >= 'a' && buf[pos] <= 'z' || buf[pos] >= 'A' && buf[pos] <= 'Z'); ++pos) {
                    }
                    if ((pos = Util.skipSpace(buf, pos)) < len && buf[pos] == ',' && pos > beg) {
                        beg = pos + 1;
                    }
                    for (pos = Util.skipSpace(buf, beg); pos < len && (Character.isDigit(buf[pos]) || buf[pos] == '-'); ++pos) {
                    }
                    if (pos < len && buf[pos] == ',') {
                        buf[pos] = 32;
                        set_cookie = new String(buf);
                    }
                }
                comma = set_cookie.indexOf(44, beg);
                semic = set_cookie.indexOf(59, beg);
                end2 = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : Math.min(comma, semic)));
                String value = set_cookie.substring(beg, end2).trim();
                legal &= Cookie.setAttribute(curr, name, value, set_cookie);
                beg = end2;
                if (beg >= len || buf[beg] != ';') continue;
                beg = Util.skipSpace(buf, beg + 1);
            }
            if (legal) {
                cookie_arr = Util.resizeArray(cookie_arr, cookie_arr.length + 1);
                cookie_arr[cookie_arr.length - 1] = curr;
                continue;
            }
            Log.write(16, "Cooki: Ignoring cookie: " + curr);
        }
        return cookie_arr;
    }

    private static boolean setAttribute(Cookie cookie, String name, String value, String set_cookie) throws ProtocolException {
        if (name.equalsIgnoreCase("expires")) {
            if (value.charAt(value.length() - 1) == '\"') {
                value = value.substring(0, value.length() - 1).trim();
            }
            try {
                cookie.expires = new Date(value);
            }
            catch (IllegalArgumentException iae) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Invalid date `" + value + "'");
            }
        } else if (name.equals("max-age")) {
            int age;
            if (cookie.expires != null) {
                return true;
            }
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1).trim();
            }
            try {
                age = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nMax-Age '" + value + "' not a number");
            }
            cookie.expires = new Date(System.currentTimeMillis() + (long)age * 1000L);
        } else if (name.equalsIgnoreCase("domain")) {
            if (value.length() == 0) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       domain is empty - ignoring domain");
                return true;
            }
            if ((value = value.toLowerCase()).length() != 0 && value.charAt(0) != '.' && !value.equals(cookie.domain)) {
                value = '.' + value;
            }
            if (!cookie.domain.endsWith(value)) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Current domain " + cookie.domain + " does not match given parsed " + value);
                return false;
            }
            if (!value.equals(".local") && value.indexOf(46, 1) == -1) {
                Log.write(16, "Cooki: Bad Set-Cookie header: " + set_cookie + "\n       Domain attribute " + value + "isn't .local and doesn't have at " + "least 2 dots");
                return false;
            }
            cookie.domain = value;
        } else if (name.equalsIgnoreCase("path")) {
            cookie.path = value;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Date expires() {
        return this.expires;
    }

    public boolean discard() {
        return this.expires == null;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean hasExpired() {
        return this.expires != null && this.expires.getTime() <= System.currentTimeMillis();
    }

    protected boolean sendWith(RoRequest req) {
        HTTPConnection con = req.getConnection();
        String eff_host = con.getHost();
        if (eff_host.indexOf(46) == -1) {
            eff_host = eff_host + ".local";
        }
        return (this.domain.charAt(0) == '.' && eff_host.endsWith(this.domain) || this.domain.charAt(0) != '.' && eff_host.equals(this.domain)) && Util.getPath(req.getRequestURI()).startsWith(this.path) && (!this.secure || con.getProtocol().equals("https") || con.getProtocol().equals("shttp"));
    }

    public int hashCode() {
        return this.name.hashCode() + this.path.hashCode() + this.domain.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            return this.name.equals(other.name) && this.path.equals(other.path) && this.domain.equals(other.domain);
        }
        return false;
    }

    protected String toExternalForm() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        StringBuffer res = new StringBuffer(this.name.length() + this.value.length() + 30);
        res.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            res.append("; expires=").append(this.expires);
        }
        if (this.path != null) {
            res.append("; path=").append(this.path);
        }
        if (this.domain != null) {
            res.append("; domain=").append(this.domain);
        }
        if (this.secure) {
            res.append("; secure");
        }
        return res.toString();
    }
}

