/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.tools.tcpproxy;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.grinder.tools.tcpproxy.EndPoint;
import net.grinder.tools.tcpproxy.TCPProxySocketFactory;
import net.grinder.tools.tcpproxy.VerboseConnectException;

final class TCPProxySocketFactoryImplementation
implements TCPProxySocketFactory {
    TCPProxySocketFactoryImplementation() {
    }

    public ServerSocket createServerSocket(EndPoint localEndPoint, int timeout) throws IOException {
        ServerSocket socket = new ServerSocket(localEndPoint.getPort(), 50, InetAddress.getByName(localEndPoint.getHost()));
        socket.setSoTimeout(timeout);
        return socket;
    }

    public Socket createClientSocket(EndPoint remoteEndPoint) throws IOException {
        try {
            return new Socket(remoteEndPoint.getHost(), remoteEndPoint.getPort());
        }
        catch (ConnectException e) {
            throw new VerboseConnectException(e, remoteEndPoint.toString());
        }
    }
}

