/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.communication;

import java.io.OutputStream;
import net.grinder.common.Closer;
import net.grinder.communication.AbstractFanOutSender;
import net.grinder.communication.Address;
import net.grinder.communication.ResourcePool;
import net.grinder.communication.ResourcePoolImplementation;
import net.grinder.util.thread.Executor;

public final class FanOutStreamSender
extends AbstractFanOutSender {
    public FanOutStreamSender(int numberOfThreads) {
        this(new Executor(numberOfThreads));
    }

    private FanOutStreamSender(Executor executor) {
        super(executor, new ResourcePoolImplementation());
    }

    public void add(OutputStream stream) {
        this.getResourcePool().add(new OutputStreamResource(stream));
    }

    public void shutdown() {
        super.shutdown();
        this.getResourcePool().closeCurrentResources();
    }

    protected OutputStream resourceToOutputStream(ResourcePool.Resource resource) {
        return ((OutputStreamResource)resource).getOutputStream();
    }

    protected Address getAddress(ResourcePool.Resource resource) {
        return null;
    }

    private static final class OutputStreamResource
    implements ResourcePool.Resource {
        private final OutputStream m_outputStream;

        public OutputStreamResource(OutputStream outputStream) {
            this.m_outputStream = outputStream;
        }

        public OutputStream getOutputStream() {
            return this.m_outputStream;
        }

        public void close() {
            Closer.close(this.m_outputStream);
        }
    }
}

