/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.__builtin__;
import org.python.modules.PyIOFile;
import org.python.modules.cStringIO;

public class PyIOFileFactory {
    private static PyType FileType = PyType.fromClass(PyFile.class);

    private PyIOFileFactory() {
    }

    public static PyIOFile createIOFile(PyObject file) {
        Object f = file.__tojava__(cStringIO.StringIO.class);
        if (f != Py.NoConversion) {
            return new cStringIOFile(file);
        }
        if (__builtin__.isinstance(file, FileType)) {
            return new FileIOFile(file);
        }
        return new ObjectIOFile(file);
    }

    static class ObjectIOFile
    implements PyIOFile {
        private char[] charr;
        private StringBuilder buff = new StringBuilder();
        private PyObject write;
        private PyObject read;
        private PyObject readline;
        private int BUF_SIZE = 256;

        ObjectIOFile(PyObject file) {
            this.write = file.__findattr__("write");
            this.read = file.__findattr__("read");
            this.readline = file.__findattr__("readline");
        }

        @Override
        public void write(String str) {
            this.buff.append(str);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        @Override
        public void write(char ch) {
            this.buff.append(ch);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        @Override
        public void flush() {
            this.write.__call__(new PyString(this.buff.toString()));
            this.buff.setLength(0);
        }

        @Override
        public String read(int len) {
            return this.read.__call__(new PyInteger(len)).toString();
        }

        @Override
        public String readlineNoNl() {
            String line = this.readline.__call__().toString();
            return line.substring(0, line.length() - 1);
        }
    }

    static class FileIOFile
    implements PyIOFile {
        private PyFile file;

        FileIOFile(PyObject file) {
            this.file = (PyFile)file.__tojava__(PyFile.class);
            if (this.file.getClosed()) {
                throw Py.ValueError("I/O operation on closed file");
            }
        }

        @Override
        public void write(String str) {
            this.file.write(str);
        }

        @Override
        public void write(char ch) {
            this.file.write(cStringIO.getString(ch));
        }

        @Override
        public void flush() {
        }

        @Override
        public String read(int len) {
            return this.file.read(len).toString();
        }

        @Override
        public String readlineNoNl() {
            String line = this.file.readline().toString();
            return line.substring(0, line.length() - 1);
        }
    }

    static class cStringIOFile
    implements PyIOFile {
        private cStringIO.StringIO file;

        cStringIOFile(PyObject file) {
            this.file = (cStringIO.StringIO)file.__tojava__(Object.class);
        }

        @Override
        public void write(String str) {
            this.file.write(str);
        }

        @Override
        public void write(char ch) {
            this.file.writeChar(ch);
        }

        @Override
        public void flush() {
        }

        @Override
        public String read(int len) {
            return this.file.read(len).asString();
        }

        @Override
        public String readlineNoNl() {
            return this.file.readlineNoNl().asString();
        }
    }
}

