/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class IsolatingClassLoader
extends URLClassLoader {
    private final String[] m_sharedPrefixes;
    private final Set m_sharedClassNames = new HashSet();
    private final boolean m_isolateParentOnly;

    public IsolatingClassLoader(URLClassLoader parent, String[] shared, boolean isolateParentOnly) {
        super(parent.getURLs(), (ClassLoader)parent);
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < shared.length; ++i) {
            int index = shared[i].indexOf(42);
            if (index >= 0) {
                prefixes.add(shared[i].substring(0, index));
                continue;
            }
            this.m_sharedClassNames.add(shared[i]);
        }
        this.m_sharedPrefixes = prefixes.toArray(new String[prefixes.size()]);
        this.m_isolateParentOnly = isolateParentOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.m_isolateParentOnly) {
            try {
                return Class.forName(name, resolve, this.getParent().getParent());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        IsolatingClassLoader isolatingClassLoader = this;
        synchronized (isolatingClassLoader) {
            boolean shared = this.m_sharedClassNames.contains(name);
            for (int i = 0; !shared && i < this.m_sharedPrefixes.length; ++i) {
                if (!name.startsWith(this.m_sharedPrefixes[i])) continue;
                shared = true;
            }
            if (!shared) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

