/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.ArrayList;
import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NKeyword;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NClassType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public final class NCall
extends NNode {
    public NNode func;
    private List<NNode> args;
    private List<NKeyword> keywords;
    private NNode kwargs;
    private NNode starargs;

    public NCall(NNode func, List<NNode> args, List<NKeyword> keywords, NNode kwargs, NNode starargs) {
        this(null, null, null, null, null, 0, 1);
    }

    public NCall(NNode func, List<NNode> args, List<NKeyword> keywords, NNode kwargs, NNode starargs, int start, int end) {
        super(start, end);
        this.func = func;
        this.args = args;
        this.keywords = keywords;
        this.kwargs = kwargs;
        this.starargs = starargs;
        this.addChildren(func, kwargs, starargs);
        this.addChildren(args);
        this.addChildren(keywords);
    }

    @Override
    public final NType resolve(Scope s) throws Exception {
        NType ft = NCall.resolveExpr(this.func, s);
        ArrayList<NType> argTypes = new ArrayList<NType>();
        for (NNode a : this.args) {
            argTypes.add(NCall.resolveExpr(a, s));
        }
        NCall.resolveList(this.keywords, s);
        NCall.resolveExpr(this.starargs, s);
        NCall.resolveExpr(this.kwargs, s);
        NType nType = ft;
        if (nType instanceof NClassType) {
            return this.setType(ft);
        }
        nType = ft;
        if (nType instanceof NFuncType) {
            nType = ft;
            nType = ((NFuncType)nType).getReturnType();
            return this.setType(NUnknownType.follow(nType));
        }
        nType = ft;
        if (nType instanceof NUnknownType) {
            NUnknownType to = new NUnknownType();
            NFuncType at = new NFuncType(to);
            NUnionType.union(ft, at);
            return this.setType(to);
        }
        this.addWarning("calling non-function " + ft);
        return this.setType(new NUnknownType());
    }

    public final String toString() {
        return "<Call:" + this.func + ":" + this.args + ":" + this.start() + ">";
    }

    @Override
    public final void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            NCall.visitNode(this.func, v);
            NCall.visitNodeList(this.args, v);
            NCall.visitNodeList(this.keywords, v);
            NCall.visitNode(this.kwargs, v);
            NCall.visitNode(this.starargs, v);
        }
    }
}

