/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyFloat;
import org.python.core.PyObject;

class RoundFunction
extends PyBuiltinFunction {
    RoundFunction() {
        super("round", "round(number[, ndigits]) -> floating point number\n\nRound a number to a given precision in decimal digits (default 0 digits).\nThis always returns a floating point number.  Precision may be negative.");
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("round", args, kwds, new String[]{"number", "ndigits"}, 0);
        PyObject number = ap.getPyObject(0);
        int ndigits = ap.getIndex(1, 0);
        return RoundFunction.round(number.asDouble(), ndigits);
    }

    private static PyFloat round(double f, int digits) {
        boolean neg = f < 0.0;
        double multiple = Math.pow(10.0, digits);
        if (neg) {
            f = -f;
        }
        double tmp = Math.floor(f * multiple + 0.5);
        if (neg) {
            tmp = -tmp;
        }
        return new PyFloat(tmp / multiple);
    }
}

