/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.antcontrib.walls.Package;
import net.sf.antcontrib.walls.Walls;
import net.sf.antcontrib.walls.WallsFileHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class CompileWithWalls
extends Task {
    private boolean setWallsTwice = false;
    private boolean setJavacTwice = false;
    private Walls walls;
    private Javac javac;
    private File wallsFile;
    private File tempBuildDir;
    private Map packagesNeedingCompiling = new HashMap();
    private SAXException cachedSAXException = null;
    private IOException cachedIOException = null;
    static /* synthetic */ Class class$net$sf$antcontrib$walls$SilentMove;
    static /* synthetic */ Class class$net$sf$antcontrib$walls$SilentCopy;

    public void setIntermediaryBuildDir(File file) {
        this.tempBuildDir = file;
    }

    public File getIntermediaryBuildDir() {
        return this.tempBuildDir;
    }

    public void setWalls(File file) {
        this.wallsFile = file;
        Parser parser = JAXPUtils.getParser();
        WallsFileHandler wallsFileHandler = new WallsFileHandler(this, this.wallsFile);
        parser.setDocumentHandler(wallsFileHandler);
        parser.setEntityResolver(wallsFileHandler);
        parser.setErrorHandler(wallsFileHandler);
        parser.setDTDHandler(wallsFileHandler);
        try {
            this.log("about to start parsing walls file", 2);
            parser.parse(this.wallsFile.toURL().toExternalForm());
        }
        catch (SAXException sAXException) {
            this.cachedSAXException = sAXException;
            throw new ParsingWallsException("Problem parsing walls file attached:", sAXException);
        }
        catch (IOException iOException) {
            this.cachedIOException = iOException;
            throw new ParsingWallsException("IOException on walls file attached:", iOException);
        }
    }

    public File getWalls() {
        return this.wallsFile;
    }

    public Walls createWalls() {
        if (this.walls != null) {
            this.setWallsTwice = true;
        }
        this.walls = new Walls();
        return this.walls;
    }

    public Javac createJavac() {
        if (this.javac != null) {
            this.setJavacTwice = true;
        }
        this.javac = new Javac();
        return this.javac;
    }

    public void execute() throws BuildException {
        if (this.cachedIOException != null) {
            throw new BuildException((Throwable)this.cachedIOException, this.getLocation());
        }
        if (this.cachedSAXException != null) {
            throw new BuildException((Throwable)this.cachedSAXException, this.getLocation());
        }
        if (this.tempBuildDir == null) {
            throw new BuildException("intermediaryBuildDir attribute must be specified on the compilewithwalls element", this.getLocation());
        }
        if (this.javac == null) {
            throw new BuildException("There must be a nested javac element", this.getLocation());
        }
        if (this.walls == null) {
            throw new BuildException("There must be a nested walls element", this.getLocation());
        }
        if (this.setWallsTwice) {
            throw new BuildException("compilewithwalls task only supports one nested walls element or one walls attribute", this.getLocation());
        }
        if (this.setJavacTwice) {
            throw new BuildException("compilewithwalls task only supports one nested javac element", this.getLocation());
        }
        this.getProject().addTaskDefinition("SilentMove", class$net$sf$antcontrib$walls$SilentMove == null ? (class$net$sf$antcontrib$walls$SilentMove = CompileWithWalls.class$("net.sf.antcontrib.walls.SilentMove")) : class$net$sf$antcontrib$walls$SilentMove);
        this.getProject().addTaskDefinition("SilentCopy", class$net$sf$antcontrib$walls$SilentCopy == null ? (class$net$sf$antcontrib$walls$SilentCopy = CompileWithWalls.class$("net.sf.antcontrib.walls.SilentCopy")) : class$net$sf$antcontrib$walls$SilentCopy);
        File file = this.javac.getDestdir();
        Path path = this.javac.getSrcdir();
        if (path == null) {
            throw new BuildException("Javac inside compilewithwalls must have a srcdir specified");
        }
        String[] stringArray = path.list();
        if (stringArray.length != 1) {
            throw new BuildException("srcdir in javac task must contain one and only one source directory with the compilewithwalls task\nYour javac srcdir contains " + stringArray.length + " source directories", this.getLocation());
        }
        File file2 = this.getProject().resolveFile(stringArray[0]);
        String[] stringArray2 = this.javac.getClasspath().list();
        File file3 = null;
        int n = 0;
        while (n < stringArray2.length) {
            file3 = new File(stringArray2[n]);
            if (file3.isDirectory() && file2.compareTo(file3) == 0) {
                throw new BuildException("The classpath cannot contain the src directory, but it does.  srcdir=" + file2);
            }
            ++n;
        }
        if (!file2.exists()) {
            throw new BuildException("srcdir \"" + file2.getPath() + "\" does not exist!", this.getLocation());
        }
        if (file == null) {
            throw new BuildException("destdir was not specified in nested javac task", this.getLocation());
        }
        if (this.file1IsChildOfFile2(this.tempBuildDir, file)) {
            throw new BuildException("intermediaryBuildDir attribute cannot be specified\nto be the same as destdir or inside desdir of the javac task.\nThis is an intermediary build directory only used by the\ncompilewithwalls task, not the class file output directory.\nThe class file output directory is specified in javac's destdir attribute", this.getLocation());
        }
        if (!this.tempBuildDir.exists()) {
            this.tempBuildDir.mkdirs();
            this.log("created direction=" + this.tempBuildDir, 3);
        }
        Iterator iterator = this.walls.getPackagesToCompile();
        while (iterator.hasNext()) {
            Package package_ = (Package)iterator.next();
            FileSet fileSet = package_.getJavaCopyFileSet(this.getProject(), this.getLocation());
            fileSet.setDir(file2);
            File file4 = package_.getBuildSpace(this.tempBuildDir);
            if (!file4.exists()) {
                file4.mkdir();
                this.log("created directory=" + file4, 3);
            }
            this.copyFiles(file2, file4, fileSet);
            Path path2 = package_.getSrcPath(this.tempBuildDir, this.getProject());
            Path path3 = package_.getClasspath(this.tempBuildDir, this.getProject());
            path3.addExisting(this.javac.getClasspath());
            Javac javac = new Javac();
            javac.setProject(this.getProject());
            javac.setOwningTarget(this.getOwningTarget());
            javac.setTaskName(this.getTaskName());
            this.log(package_.getPackage() + ": Compiling");
            this.log(package_.getPackage() + ": sourceDir=" + path2, 3);
            this.log(package_.getPackage() + ": classPath=" + path3, 3);
            this.log(package_.getPackage() + ": destDir=" + file4, 3);
            javac.setSrcdir(path2);
            javac.setDestdir(file4);
            javac.setClasspath(path3);
            javac.setBootclasspath(this.javac.getBootclasspath());
            javac.setExtdirs(this.javac.getExtdirs());
            javac.setEncoding(this.javac.getEncoding());
            javac.setNowarn(this.javac.getNowarn());
            javac.setDebug(this.javac.getDebug());
            javac.setDebugLevel(this.javac.getDebugLevel());
            javac.setOptimize(this.javac.getOptimize());
            javac.setDeprecation(this.javac.getDeprecation());
            javac.setTarget(this.javac.getTarget());
            javac.setVerbose(this.javac.getVerbose());
            javac.setDepend(this.javac.getDepend());
            javac.setIncludeantruntime(this.javac.getIncludeantruntime());
            javac.setIncludejavaruntime(this.javac.getIncludejavaruntime());
            javac.setFork(this.javac.isForkedJavac());
            javac.setExecutable(this.javac.getJavacExecutable());
            javac.setMemoryInitialSize(this.javac.getMemoryInitialSize());
            javac.setMemoryMaximumSize(this.javac.getMemoryMaximumSize());
            javac.setFailonerror(this.javac.getFailonerror());
            javac.setSource(this.javac.getSource());
            javac.setCompiler(this.javac.getCompiler());
            String[] stringArray3 = this.javac.getCurrentCompilerArgs();
            if (stringArray3 != null) {
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    Javac.ImplementationSpecificArgument implementationSpecificArgument = javac.createCompilerArg();
                    implementationSpecificArgument.setValue(stringArray3[n2]);
                    ++n2;
                }
            }
            javac.setProject(this.getProject());
            javac.perform();
            this.copyFiles(file4, file, package_.getClassCopyFileSet(this.getProject(), this.getLocation()));
        }
    }

    private boolean file1IsChildOfFile2(File file, File file2) {
        File file3 = file;
        int n = 0;
        while (n < 1000) {
            if (file3.compareTo(file2) == 0) {
                return true;
            }
            if ((file3 = file3.getParentFile()) == null) {
                return false;
            }
            ++n;
        }
        throw new RuntimeException("You either have more than 1000 directories in\nyour heirarchy or this is a bug, please report. parent=" + file3 + "  destDir=" + file2);
    }

    private void copyFiles(File file, File file2, FileSet fileSet) {
        fileSet.setDir(file);
        if (!file.exists()) {
            throw new BuildException("Directory=" + file + " does not exist", this.getLocation());
        }
        Copy copy = (Copy)this.getProject().createTask("SilentCopy");
        copy.setProject(this.getProject());
        copy.setOwningTarget(this.getOwningTarget());
        copy.setTaskName(this.getTaskName());
        copy.setLocation(this.getLocation());
        copy.setTodir(file2);
        copy.addFileset(fileSet);
        copy.perform();
    }

    public void log(String string, int n) {
        super.log(string, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ParsingWallsException
    extends RuntimeException {
        private String message;

        public ParsingWallsException(String string, Throwable throwable) {
            super(string);
            this.message = string + "\n";
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            this.message = this.message + stringWriter;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

