/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.python.google.common.base.CharMatcher;
import org.python.google.common.base.Function;
import org.python.google.common.base.Joiner;
import org.python.google.common.collect.FluentIterable;
import org.python.google.common.collect.Iterators;

public final class Collections2 {
    static final Joiner STANDARD_JOINER = Joiner.on(", ").useForNull("null");

    static boolean containsAllImpl(Collection<?> self, Collection<?> c) {
        CharMatcher.LookupTable.checkNotNull(self);
        for (Object o : c) {
            if (self.contains(o)) continue;
            return false;
        }
        return true;
    }

    static String toStringImpl(Collection<?> collection) {
        StringBuilder sb = Collections2.newStringBuilderForCollection(collection.size()).append('[');
        Function<Object, Object> function = new Function<Object, Object>(collection){
            private /* synthetic */ Collection val$collection;
            {
                this.val$collection = collection;
            }

            @Override
            public final Object apply(Object input) {
                if (input == this.val$collection) {
                    return "(this Collection)";
                }
                return input;
            }

            static int smear(int hashCode) {
                hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
                return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
            }

            static int hashCodeImpl(Set<?> s) {
                int hashCode = 0;
                for (Object o : s) {
                    hashCode += o != null ? o.hashCode() : 0;
                }
                return hashCode;
            }

            static boolean equalsImpl(Set<?> s, Object object) {
                if (s == object) {
                    return true;
                }
                if (object instanceof Set) {
                    Set o = (Set)object;
                    try {
                        return s.size() == o.size() && s.containsAll(o);
                    }
                    catch (NullPointerException nullPointerException) {
                        return false;
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                }
                return false;
            }
        };
        Collection<?> collection2 = collection;
        CharMatcher.LookupTable.checkNotNull(collection2);
        CharMatcher.LookupTable.checkNotNull(function);
        STANDARD_JOINER.appendTo(sb, new FluentIterable<T>(collection2, function){
            private /* synthetic */ Iterable val$fromIterable;
            private /* synthetic */ Function val$function;
            {
                this.val$fromIterable = iterable;
                this.val$function = function;
            }

            public final Iterator<T> iterator() {
                return Iterators.transform(this.val$fromIterable.iterator(), this.val$function);
            }
        });
        return sb.append(']').toString();
    }

    static StringBuilder newStringBuilderForCollection(int size) {
        CharMatcher.LookupTable.checkArgument(size >= 0, "size must be non-negative");
        return new StringBuilder((int)Math.min((long)size << 3, 0x40000000L));
    }

    static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }
}

