/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleBuffer;

public class ZeroByteBuffer
extends BaseBuffer {
    private static final byte[] EMPTY = new byte[0];
    protected static final int[] SHAPE = new int[]{0};

    public ZeroByteBuffer(int flags, boolean readonly) throws PyException {
        super(0xE0 | (readonly ? 0 : 1));
        this.storage = EMPTY;
        this.shape = SHAPE;
        this.strides = SimpleBuffer.SIMPLE_STRIDES;
        this.checkRequestFlags(flags);
    }

    @Override
    public int getLen() {
        return 0;
    }

    @Override
    protected int calcIndex(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected int calcIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices);
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void copyTo(byte[] dest, int destPos) throws IndexOutOfBoundsException {
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int length) throws IndexOutOfBoundsException, PyException {
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int length) throws IndexOutOfBoundsException, PyException {
        if (length > 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        if (src.getLen() > 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length) {
        if (start == 0 && length <= 0) {
            return this.getBuffer(flags);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        return this.getBufferSlice(flags, start, length);
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        return new PyBuffer.Pointer(EMPTY, 0);
    }

    @Override
    public String toString() {
        return "";
    }

    static class View
    extends ZeroByteBuffer {
        private PyBuffer root;

        public View(PyBuffer root, int flags) {
            super(flags, root.isReadonly());
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

