/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyFloatConstant
extends Constant
implements ClassConstants,
Opcodes {
    private static final double ZERO = 0.0;
    private double value;

    PyFloatConstant(double value) {
        this.value = value;
    }

    @Override
    final void get(Code c) throws IOException {
        c.ldc(new Double(this.value));
        c.invokestatic(CodegenUtils.p(Py.class), "newFloat", CodegenUtils.sig(PyFloat.class, Double.TYPE));
    }

    @Override
    final void put(Code c) throws IOException {
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof PyFloatConstant) {
            double oVal = ((PyFloatConstant)o).value;
            if (0.0 == this.value) {
                return oVal == this.value && Double.toString(oVal).equals(Double.toString(this.value));
            }
            return oVal == this.value;
        }
        return false;
    }
}

