/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.python.antlr.ParseException;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.alias;
import org.python.antlr.base.mod;
import org.python.antlr.base.stmt;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.FutureFeature;
import org.python.core.Pragma;
import org.python.core.PragmaReceiver;

public class Future {
    Set<FutureFeature> featureSet = EnumSet.noneOf(FutureFeature.class);
    private final PragmaReceiver features = new PragmaReceiver(this){
        private /* synthetic */ Future this$0;
        {
            this.this$0 = future;
        }

        @Override
        public void add(Pragma pragma) {
            if (pragma instanceof FutureFeature) {
                FutureFeature feature = (FutureFeature)pragma;
                this.this$0.featureSet.add(feature);
            }
        }
    };

    private boolean check(ImportFrom cand) throws Exception {
        if (!cand.getInternalModule().equals("__future__")) {
            return false;
        }
        if (cand.getInternalNames().isEmpty()) {
            throw new ParseException("future statement does not support import *", cand);
        }
        try {
            for (alias feature : cand.getInternalNames()) {
                FutureFeature.addFeature(feature.getInternalName(), this.features);
            }
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage(), cand);
        }
        return true;
    }

    public void preprocessFutures(mod node, CompilerFlags cflags) throws Exception {
        stmt s;
        List<stmt> suite;
        if (cflags != null) {
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                FutureFeature.division.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_WITH_STATEMENT)) {
                FutureFeature.with_statement.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT)) {
                FutureFeature.absolute_import.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_PRINT_FUNCTION)) {
                FutureFeature.print_function.addTo(this.features);
            }
            if (cflags.isFlagSet(CodeFlag.CO_FUTURE_UNICODE_LITERALS)) {
                FutureFeature.unicode_literals.addTo(this.features);
            }
        }
        int beg = 0;
        if (node instanceof Module) {
            suite = ((Module)node).getInternalBody();
            if (suite.size() > 0 && suite.get(0) instanceof Expr && ((Expr)suite.get(0)).getInternalValue() instanceof Str) {
                ++beg;
            }
        } else if (node instanceof Interactive) {
            suite = ((Interactive)node).getInternalBody();
        } else {
            return;
        }
        for (int i = beg; i < suite.size() && (s = suite.get(i)) instanceof ImportFrom; ++i) {
            s.from_future_checked = true;
            if (!this.check((ImportFrom)s)) break;
        }
        if (cflags != null) {
            for (FutureFeature feature : this.featureSet) {
                feature.setFlag(cflags);
            }
        }
    }

    public static void checkFromFuture(ImportFrom node) throws Exception {
        if (node.from_future_checked) {
            return;
        }
        if (node.getInternalModule().equals("__future__")) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", node);
        }
        node.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.featureSet.contains(FutureFeature.division);
    }

    public boolean withStatementSupported() {
        return this.featureSet.contains(FutureFeature.with_statement);
    }

    public boolean isAbsoluteImportOn() {
        return this.featureSet.contains(FutureFeature.absolute_import);
    }
}

